/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.utils;

import io.hcxprotocol.dto.HttpResponse;
import io.hcxprotocol.exception.ServerException;
import io.hcxprotocol.init.HCXIntegrator;
import io.hcxprotocol.utils.HttpUtils;
import io.hcxprotocol.utils.JSONUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class Utils {
    public static String generateToken() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/x-www-form-urlencoded");
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("client_id", "registry-frontend");
        fields.put("username", HCXIntegrator.getInstance().getUsername());
        fields.put("password", HCXIntegrator.getInstance().getPassword());
        fields.put("grant_type", "password");
        HttpResponse response = HttpUtils.post(HCXIntegrator.getInstance().getAuthBasePath(), headers, fields);
        Map responseBody = null;
        responseBody = JSONUtils.deserialize(response.getBody(), Map.class);
        return (String)responseBody.get("access_token");
    }

    public static Map<String, Object> searchRegistry(Object participantCode) throws Exception {
        String filter = "{\"filters\":{\"participant_code\":{\"eq\":\"" + participantCode + "\"}}}";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + Utils.generateToken());
        HttpResponse response = HttpUtils.post(HCXIntegrator.getInstance().getHCXProtocolBasePath() + "/participant/search", headers, filter);
        if (response.getStatus() != 200) {
            throw new ServerException("Error in fetching the participant details" + response.getStatus());
        }
        Map respMap = JSONUtils.deserialize(response.getBody(), Map.class);
        List details = (List)respMap.get("participants");
        return !details.isEmpty() ? (Map)details.get(0) : new HashMap();
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

