/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.jwe;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.util.Base64URL;
import io.hcxprotocol.jwe.JweRequestInterface;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class JweRequest
implements JweRequestInterface {
    public static final JWEAlgorithm KEY_MANAGEMENT_ALGORITHM = JWEAlgorithm.RSA_OAEP_256;
    public static final EncryptionMethod CONTENT_ENCRYPTION_ALGORITHM = EncryptionMethod.A256GCM;
    private Map<String, Object> headers;
    private Map<String, Object> payload;
    private Map<String, String> encryptedObject;
    private Map<String, String> deserializedObject;

    public JweRequest(Map<String, Object> headers, Map<String, Object> payload) {
        this.headers = headers;
        this.payload = payload;
    }

    public JweRequest(Map<String, String> encryptedObject) {
        this.encryptedObject = encryptedObject;
    }

    @Override
    public Map<String, String> getEncryptedObject() {
        return this.encryptedObject;
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, Object> getPayload() {
        return this.payload;
    }

    @Override
    public void encryptRequest(RSAPublicKey rsaPublicKey) throws JOSEException {
        JWEHeader jweHeader = new JWEHeader.Builder(KEY_MANAGEMENT_ALGORITHM, CONTENT_ENCRYPTION_ALGORITHM).customParams(this.headers).build();
        Payload jwePayload = new Payload(this.payload);
        JWEObject jweObject = new JWEObject(jweHeader, jwePayload);
        RSAEncrypter rsaEncrypter = new RSAEncrypter(rsaPublicKey);
        jweObject.encrypt((JWEEncrypter)rsaEncrypter);
        String serializedString = jweObject.serialize();
        this.encryptedObject = new HashMap<String, String>();
        this.encryptedObject.put("payload", serializedString);
    }

    private void buildEncryptedObjectFromString(String serializedString) {
        String[] jweParts = serializedString.split("\\.");
        this.deserializedObject = new HashMap<String, String>();
        this.deserializedObject.put("protected", jweParts[0]);
        this.deserializedObject.put("encrypted_key", jweParts[1]);
        this.deserializedObject.put("iv", jweParts[2]);
        this.deserializedObject.put("ciphertext", jweParts[3]);
        this.deserializedObject.put("tag", jweParts[4]);
    }

    @Override
    public void decryptRequest(RSAPrivateKey rsaPrivateKey) throws ParseException, JOSEException {
        this.buildEncryptedObjectFromString(this.encryptedObject.get("payload"));
        JWEObject jweObject = new JWEObject(new Base64URL(this.deserializedObject.get("protected")), new Base64URL(this.deserializedObject.get("encrypted_key")), new Base64URL(this.deserializedObject.get("iv")), new Base64URL(this.deserializedObject.get("ciphertext")), new Base64URL(this.deserializedObject.get("tag")));
        RSADecrypter jweDecrypter = new RSADecrypter((PrivateKey)rsaPrivateKey);
        jweObject.decrypt((JWEDecrypter)jweDecrypter);
        this.headers = jweObject.getHeader().toJSONObject();
        this.payload = new HashMap<String, Object>(jweObject.getPayload().toJSONObject());
    }
}

