/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.init;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HCXIntegrator {
    static HCXIntegrator hcxIntegrator = null;
    private static Config config = null;

    private HCXIntegrator() {
    }

    public static HCXIntegrator getInstance() throws Exception {
        if (config == null) {
            throw new Exception("Please initialize the configuration variables, in order to initialize the SDK");
        }
        HCXIntegrator.validateConfig();
        if (hcxIntegrator == null) {
            hcxIntegrator = new HCXIntegrator();
        }
        return hcxIntegrator;
    }

    public static void init(Map<String, Object> configMap) {
        config = ConfigFactory.parseMap(configMap);
    }

    public static void init(String configStr) {
        config = ConfigFactory.parseString((String)configStr);
    }

    private static void validateConfig() throws Exception {
        List<String> props = Arrays.asList("protocolBasePath", "participantCode", "authBasePath", "username", "password", "encryptionPrivateKey", "igUrl");
        for (String prop : props) {
            if (config.hasPathOrNull(prop) && !StringUtils.isEmpty((CharSequence)config.getString(prop))) continue;
            throw new Exception(prop + " is missing or has empty value, please add to the configuration.");
        }
    }

    public String getHCXProtocolBasePath() {
        return config.getString("protocolBasePath");
    }

    public String getParticipantCode() {
        return config.getString("participantCode");
    }

    public String getAuthBasePath() {
        return config.getString("authBasePath");
    }

    public String getUsername() {
        return config.getString("username");
    }

    public String getPassword() {
        return config.getString("password");
    }

    public String getPrivateKey() {
        return config.getString("encryptionPrivateKey");
    }

    public String getIGUrl() {
        return config.getString("igUrl");
    }
}

