/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.impl;

import io.hcxprotocol.dto.HttpResponse;
import io.hcxprotocol.exception.ErrorCodes;
import io.hcxprotocol.helper.FhirPayload;
import io.hcxprotocol.init.HCXIntegrator;
import io.hcxprotocol.interfaces.OutgoingRequest;
import io.hcxprotocol.jwe.JweRequest;
import io.hcxprotocol.key.PublicKeyLoader;
import io.hcxprotocol.utils.HttpUtils;
import io.hcxprotocol.utils.JSONUtils;
import io.hcxprotocol.utils.Operations;
import io.hcxprotocol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class HCXOutgoingRequest
extends FhirPayload
implements OutgoingRequest {
    private final HCXIntegrator hcxIntegrator = HCXIntegrator.getInstance();

    @Override
    public boolean generate(String fhirPayload, Operations operation, String recipientCode, Map<String, Object> output) {
        return this.process(fhirPayload, operation, recipientCode, "", "", output);
    }

    @Override
    public boolean generate(String fhirPayload, Operations operation, String actionJwe, String onActionStatus, Map<String, Object> output) {
        return this.process(fhirPayload, operation, "", actionJwe, onActionStatus, output);
    }

    private boolean process(String fhirPayload, Operations operation, String recipientCode, String actionJwe, String onActionStatus, Map<String, Object> output) {
        boolean result = false;
        try {
            HashMap<String, Object> error = new HashMap<String, Object>();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            HashMap<String, Object> response = new HashMap<String, Object>();
            if (!this.validatePayload(fhirPayload, operation, error)) {
                output.putAll(error);
            } else if (!this.createHeader(recipientCode, actionJwe, onActionStatus, headers)) {
                output.putAll(error);
            } else if (!this.encryptPayload(headers, fhirPayload, output)) {
                output.putAll(error);
            } else {
                result = this.initializeHCXCall(JSONUtils.serialize(output), operation, response);
                output.putAll(response);
            }
            return result;
        }
        catch (Exception ex) {
            output.put(ErrorCodes.ERR_DOMAIN_PROCESSING.toString(), ex.getMessage());
            return result;
        }
    }

    @Override
    public boolean createHeader(String recipientCode, String actionJwe, String onActionStatus, Map<String, Object> headers) {
        try {
            headers.put("alg", "A256GCM");
            headers.put("enc", "RSA-OAEP");
            headers.put("x-hcx-api_call_id", UUID.randomUUID().toString());
            headers.put("x-hcx-timestamp", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").format(new Date()));
            if (!StringUtils.isEmpty((CharSequence)recipientCode)) {
                headers.put("x-hcx-sender_code", this.hcxIntegrator.getParticipantCode());
                headers.put("x-hcx-recipient_code", recipientCode);
                headers.put("x-hcx-correlation_id", UUID.randomUUID().toString());
            } else {
                Map actionHeaders = JSONUtils.decodeBase64String(actionJwe.split("\\.")[0], Map.class);
                headers.put("x-hcx-sender_code", actionHeaders.get("x-hcx-recipient_code"));
                headers.put("x-hcx-recipient_code", actionHeaders.get("x-hcx-sender_code"));
                headers.put("x-hcx-correlation_id", actionHeaders.get("x-hcx-correlation_id"));
                headers.put("x-hcx-status", onActionStatus);
                if (headers.containsKey("x-hcx-workflow_id")) {
                    headers.put("x-hcx-workflow_id", actionHeaders.get("x-hcx-workflow_id"));
                }
            }
            return true;
        }
        catch (Exception e) {
            headers.put("error", "Error while creating headers: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean encryptPayload(Map<String, Object> headers, String fhirPayload, Map<String, Object> output) {
        try {
            String publicKeyUrl = (String)Utils.searchRegistry(headers.get("x-hcx-recipient_code")).get("encryption_cert");
            String certificate = IOUtils.toString((URL)new URL(publicKeyUrl), (String)StandardCharsets.UTF_8.toString());
            ByteArrayInputStream stream = new ByteArrayInputStream(certificate.getBytes());
            InputStreamReader fileReader = new InputStreamReader(stream);
            RSAPublicKey rsaPublicKey = PublicKeyLoader.loadPublicKeyFromX509Certificate(fileReader);
            JweRequest jweRequest = new JweRequest(headers, JSONUtils.deserialize(fhirPayload, Map.class));
            jweRequest.encryptRequest(rsaPublicKey);
            output.putAll(jweRequest.getEncryptedObject());
            return true;
        }
        catch (Exception e) {
            output.put("error", e.getMessage());
            return false;
        }
    }

    @Override
    public boolean initializeHCXCall(String jwePayload, Operations operation, Map<String, Object> response) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + Utils.generateToken());
        HttpResponse hcxResponse = HttpUtils.post(this.hcxIntegrator.getHCXProtocolBasePath() + operation.getOperation(), headers, jwePayload);
        response.put("responseObj", JSONUtils.deserialize(hcxResponse.getBody(), Map.class));
        return hcxResponse.getStatus() == 202;
    }
}

