/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.impl;

import io.hcxprotocol.dto.ResponseError;
import io.hcxprotocol.exception.ErrorCodes;
import io.hcxprotocol.helper.FhirPayload;
import io.hcxprotocol.helper.ValidateHelper;
import io.hcxprotocol.init.HCXIntegrator;
import io.hcxprotocol.interfaces.IncomingRequest;
import io.hcxprotocol.jwe.JweRequest;
import io.hcxprotocol.utils.JSONUtils;
import io.hcxprotocol.utils.Operations;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class HCXIncomingRequest
extends FhirPayload
implements IncomingRequest {
    private final HCXIntegrator hcxIntegrator = HCXIntegrator.getInstance();

    @Override
    public boolean process(String jwePayload, Operations operation, Map<String, Object> output) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        boolean result = false;
        if (!this.validateRequest(jwePayload, operation, error)) {
            this.sendResponse(error, output);
        } else if (!this.decryptPayload(jwePayload, output)) {
            this.sendResponse(output, output);
        } else if (!this.validatePayload((String)output.get("fhirPayload"), operation, error)) {
            this.sendResponse(error, output);
        } else if (this.sendResponse(error, output)) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean validateRequest(String jwePayload, Operations operation, Map<String, Object> error) {
        return ValidateHelper.getInstance().validateRequest(jwePayload, operation, error);
    }

    @Override
    public boolean decryptPayload(String jwePayload, Map<String, Object> output) {
        try {
            JweRequest jweRequest = new JweRequest(JSONUtils.deserialize(jwePayload, Map.class));
            jweRequest.decryptRequest(HCXIncomingRequest.getRsaPrivateKey(this.hcxIntegrator.getPrivateKey()));
            output.put("headers", jweRequest.getHeaders());
            output.put("fhirPayload", JSONUtils.serialize(jweRequest.getPayload()));
            return true;
        }
        catch (Exception e) {
            output.put(ErrorCodes.ERR_INVALID_ENCRYPTION.toString(), e.getMessage());
            return false;
        }
    }

    private static RSAPrivateKey getRsaPrivateKey(String privateKey) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        ByteArrayInputStream stream = new ByteArrayInputStream(privateKey.getBytes());
        InputStreamReader fileReader = new InputStreamReader(stream);
        PemReader pemReader = new PemReader((Reader)fileReader);
        PemObject pemObject = pemReader.readPemObject();
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
        KeyFactory factory = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)factory.generatePrivate(privateKeySpec);
    }

    @Override
    public boolean sendResponse(Map<String, Object> error, Map<String, Object> output) {
        HashMap<String, Object> responseObj = new HashMap<String, Object>();
        responseObj.put("timestamp", System.currentTimeMillis());
        boolean result = false;
        if (error.isEmpty()) {
            Map headers = (Map)output.get("headers");
            responseObj.put("api_call_id", headers.get("x-hcx-api_call_id"));
            responseObj.put("correlation_id", headers.get("x-hcx-correlation_id"));
            result = true;
        } else {
            String code = (String)error.keySet().toArray()[0];
            responseObj.put("error", new ResponseError(code, (String)error.get(code), ""));
        }
        output.put("responseObj", responseObj);
        return result;
    }
}

