/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.helper;

import io.hcxprotocol.dto.JSONRequest;
import io.hcxprotocol.dto.JWERequest;
import io.hcxprotocol.exception.ErrorCodes;
import io.hcxprotocol.utils.JSONUtils;
import io.hcxprotocol.utils.Operations;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValidateHelper {
    private static ValidateHelper validateHelper = null;

    private ValidateHelper() {
    }

    public static ValidateHelper getInstance() {
        if (validateHelper == null) {
            validateHelper = new ValidateHelper();
        }
        return validateHelper;
    }

    public boolean validateRequest(String payload, Operations operation, Map<String, Object> error) {
        try {
            Map requestBody = JSONUtils.deserialize(payload, HashMap.class);
            if (requestBody.containsKey("payload")) {
                if (this.validateJWERequest(operation, error, requestBody)) {
                    return false;
                }
            } else {
                if (!operation.toString().contains("ON_")) {
                    error.put(ErrorCodes.ERR_INVALID_PAYLOAD.toString(), "Request body should be a proper JWE object for action API calls");
                    return false;
                }
                if (!this.validateJsonRequest(operation, error, requestBody)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            error.put(ErrorCodes.ERR_INVALID_PAYLOAD.toString(), e.getMessage());
            return false;
        }
        return true;
    }

    private boolean validateJWERequest(Operations operation, Map<String, Object> error, Map<String, Object> requestBody) throws Exception {
        JWERequest jweRequest = new JWERequest(requestBody);
        String[] payloadArr = jweRequest.getPayloadValues();
        if (jweRequest.validateJwePayload(error, payloadArr)) {
            return true;
        }
        return jweRequest.validateHeadersData(List.of("alg", "enc", "x-hcx-sender_code", "x-hcx-recipient_code", "x-hcx-api_call_id", "x-hcx-timestamp", "x-hcx-correlation_id"), operation, error);
    }

    boolean validateJsonRequest(Operations operation, Map<String, Object> error, Map<String, Object> requestBody) throws Exception {
        JSONRequest jsonRequest = new JSONRequest(requestBody);
        if ("response.error".equalsIgnoreCase(jsonRequest.getStatus())) {
            return jsonRequest.validateHeadersData(List.of("x-hcx-status", "x-hcx-sender_code", "x-hcx-recipient_code", "x-hcx-error_details", "x-hcx-correlation_id", "x-hcx-api_call_id", "x-hcx-timestamp"), operation, error);
        }
        if (jsonRequest.validateHeadersData(List.of("x-hcx-sender_code", "x-hcx-recipient_code", "x-hcx-api_call_id", "x-hcx-timestamp", "x-hcx-correlation_id", "x-hcx-status", "x-hcx-redirect_to"), operation, error)) {
            return true;
        }
        return jsonRequest.validateRedirect(error);
    }
}

