/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.dto;

import io.hcxprotocol.exception.ErrorCodes;
import io.hcxprotocol.utils.Constants;
import io.hcxprotocol.utils.DateTimeUtils;
import io.hcxprotocol.utils.JSONUtils;
import io.hcxprotocol.utils.Operations;
import io.hcxprotocol.utils.UUIDUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BaseRequest {
    public Map<String, Object> protocolHeaders;
    Map<String, Object> payload;

    public BaseRequest(Map<String, Object> payload) throws Exception {
        this.payload = payload;
        this.protocolHeaders = payload.containsKey("payload") ? JSONUtils.decodeBase64String(this.getPayloadValues()[0], Map.class) : payload;
    }

    public String getWorkflowId() {
        return this.getHeader("x-hcx-workflow_id");
    }

    public String getApiCallId() {
        return this.getHeader("x-hcx-api_call_id");
    }

    public String getCorrelationId() {
        return this.getHeader("x-hcx-correlation_id");
    }

    public String getHcxSenderCode() {
        return this.getHeader("x-hcx-sender_code");
    }

    public String getTimestamp() {
        return this.getHeader("x-hcx-timestamp");
    }

    public String getDebugFlag() {
        return this.getHeader("x-hcx-debug_flag");
    }

    public String getStatus() {
        return this.getHeader("x-hcx-status");
    }

    protected String getHeader(String key) {
        return (String)this.protocolHeaders.getOrDefault(key, "");
    }

    public Map<String, Object> getPayload() {
        return this.payload;
    }

    protected Map<String, Object> getHeaderMap(String key) {
        return this.protocolHeaders.getOrDefault(key, new HashMap());
    }

    private void setHeaderMap(String key, Object value) {
        this.protocolHeaders.put(key, value);
    }

    public Map<String, Object> getErrorDetails() {
        return this.getHeaderMap("x-hcx-error_details");
    }

    public Map<String, Object> getDebugDetails() {
        return this.getHeaderMap("x-hcx-debug_details");
    }

    public String getRedirectTo() {
        return this.getHeader("x-hcx-redirect_to");
    }

    public String[] getPayloadValues() {
        return ((String)this.getPayload().get("payload")).split("\\.");
    }

    public boolean validateHeadersData(List<String> mandatoryHeaders, Operations operation, Map<String, Object> error) {
        List missingHeaders = mandatoryHeaders.stream().filter(key -> !this.protocolHeaders.containsKey(key)).collect(Collectors.toList());
        if (!missingHeaders.isEmpty()) {
            error.put(ErrorCodes.ERR_MANDATORY_HEADER_MISSING.toString(), MessageFormat.format("Mandatory headers are missing: {0}", missingHeaders));
            return true;
        }
        if (this.validateCondition(!UUIDUtils.isUUID(this.getApiCallId()), error, ErrorCodes.ERR_INVALID_API_CALL_ID.toString(), "API call id should be a valid UUID")) {
            return true;
        }
        if (this.validateCondition(!UUIDUtils.isUUID(this.getCorrelationId()), error, ErrorCodes.ERR_INVALID_CORRELATION_ID.toString(), "Correlation id should be a valid UUID")) {
            return true;
        }
        if (this.validateCondition(!DateTimeUtils.validTimestamp(this.getTimestamp()), error, ErrorCodes.ERR_INVALID_TIMESTAMP.toString(), "Timestamp cannot be in future date")) {
            return true;
        }
        if (this.validateCondition(this.protocolHeaders.containsKey("x-hcx-workflow_id") && !UUIDUtils.isUUID(this.getWorkflowId()), error, ErrorCodes.ERR_INVALID_WORKFLOW_ID.toString(), "Workflow id should be a valid UUID")) {
            return true;
        }
        this.validateOptionalHeaders(error);
        this.validateOnAction(operation, error);
        return false;
    }

    public boolean validateJwePayload(Map<String, Object> error, String[] payloadArr) {
        if (payloadArr != null && payloadArr.length != 5) {
            error.put(ErrorCodes.ERR_INVALID_PAYLOAD.toString(), "Mandatory elements of JWE token are missing.Should have all 5 elements");
            return true;
        }
        if (payloadArr != null) {
            for (String value : payloadArr) {
                if (value != null && !value.isEmpty()) continue;
                error.put(ErrorCodes.ERR_INVALID_PAYLOAD.toString(), "Payload contains null or empty values");
                return true;
            }
        }
        return false;
    }

    public boolean validateCondition(Boolean condition, Map<String, Object> error, String key, String msg) {
        if (condition.booleanValue()) {
            error.put(key, msg);
            return true;
        }
        return false;
    }

    public boolean validateDetails(Map<String, Object> inputMap, Map<String, Object> error, String errorKey, String msg, List<String> rangeValues, String rangeMsg) {
        if (MapUtils.isEmpty(inputMap)) {
            error.put(errorKey, msg);
            return true;
        }
        if (!inputMap.containsKey("code") || !inputMap.containsKey("message")) {
            error.put(errorKey, msg);
            return true;
        }
        for (String key : inputMap.keySet()) {
            if (rangeValues.contains(key)) continue;
            error.put(key, rangeMsg);
            return true;
        }
        return false;
    }

    public boolean validateOptionalHeaders(Map<String, Object> error) {
        if (this.protocolHeaders.containsKey("x-hcx-debug_flag") && this.validateValues(this.getDebugFlag(), error, ErrorCodes.ERR_INVALID_DEBUG_FLAG.toString(), "Debug flag cannot be null, empty and other than 'String'", Constants.DEBUG_FLAG_VALUES, MessageFormat.format("Debug flag cannot be other than {0}", Constants.DEBUG_FLAG_VALUES))) {
            return true;
        }
        if (this.protocolHeaders.containsKey("x-hcx-error_details")) {
            if (this.validateDetails(this.getErrorDetails(), error, ErrorCodes.ERR_INVALID_ERROR_DETAILS.toString(), "Error details cannot be null, empty and other than 'JSON Object' with mandatory fields code or message", Constants.ERROR_DETAILS_VALUES, MessageFormat.format("Error details should contain only: {0}", Constants.ERROR_DETAILS_VALUES))) {
                return true;
            }
            if (this.validateCondition(!Constants.RECIPIENT_ERROR_VALUES.contains(((Map)this.protocolHeaders.get("x-hcx-error_details")).get("code")), error, ErrorCodes.ERR_INVALID_ERROR_DETAILS.toString(), "Invalid Error Code")) {
                return true;
            }
        }
        if (this.protocolHeaders.containsKey("x-hcx-debug_details")) {
            return this.validateDetails(this.getDebugDetails(), error, ErrorCodes.ERR_INVALID_DEBUG_DETAILS.toString(), "Debug details cannot be null, empty and other than 'JSON Object' with mandatory fields code or message", Constants.ERROR_DETAILS_VALUES, MessageFormat.format("Debug details should contain only: {0}", Constants.ERROR_DETAILS_VALUES));
        }
        return false;
    }

    public boolean validateOnAction(Operations operation, Map<String, Object> error) {
        if (operation.getOperation().contains("on_")) {
            if (this.validateCondition(!this.protocolHeaders.containsKey("x-hcx-status"), error, ErrorCodes.ERR_INVALID_STATUS.toString(), MessageFormat.format("Mandatory headers are missing: {0}", "x-hcx-status"))) {
                return true;
            }
            return this.validateValues(this.getStatus(), error, ErrorCodes.ERR_INVALID_STATUS.toString(), "Status cannot be null, empty and other than 'String'", Constants.RESPONSE_STATUS_VALUES, MessageFormat.format("Status value for on_action API calls can be only: {0}", Constants.RESPONSE_STATUS_VALUES));
        }
        if (this.protocolHeaders.containsKey("x-hcx-status")) {
            return this.validateValues(this.getStatus(), error, ErrorCodes.ERR_INVALID_STATUS.toString(), "Status cannot be null, empty and other than 'String'", Constants.REQUEST_STATUS_VALUES, MessageFormat.format("Status value for action API calls can be only: {0}", Constants.REQUEST_STATUS_VALUES));
        }
        return false;
    }

    public boolean validateValues(String inputStr, Map<String, Object> error, String key, String msg, List<String> statusValues, String rangeMsg) {
        if (StringUtils.isEmpty((CharSequence)inputStr)) {
            error.put(key, msg);
            return true;
        }
        if (!statusValues.contains(inputStr)) {
            error.put(key, rangeMsg);
            return true;
        }
        return false;
    }
}

