/*
 * Decompiled with CFR 0.152.
 */
package io.hcxprotocol.createresource;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Collections;
import java.util.UUID;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.UrlType;

@ResourceDef(name="InsurancePlan", profile="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXInsurancePlan.html")
public class HCXInsurancePlan
extends InsurancePlan {
    public HCXInsurancePlan() {
    }

    public HCXInsurancePlan(String identifier, Enumerations.PublicationStatus status, String name) {
        this.setId(UUID.randomUUID().toString());
        Meta meta = new Meta();
        meta.setProfile(Collections.singletonList(new CanonicalType("https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXInsurancePlan.html")));
        this.setMeta(meta);
        this.getIdentifier().add(new Identifier().setValue(identifier));
        this.setStatus(status);
        this.setType(Collections.singletonList(new CodeableConcept().setCoding(Collections.singletonList(new Coding().setCode("medical").setSystem("http://terminology.hl7.org/CodeSystem/insurance-plan-type")))));
        this.setName(name);
    }

    @Block
    public static class QuestionnairesExtension
    extends BackboneElement {
        private static final long serialVersionUID = 4522090347756045148L;
        @Child(name="questionnaire")
        @Extension(url="Questionnaire", definedLocally=false, isModifier=false)
        private Reference questionnaire;
        @Child(name="questionnaireRequiredFlag")
        @Extension(url="QuestionnaireRequiredFlag", definedLocally=false, isModifier=false)
        private BooleanType questionnaireRequiredFlag;
        @Child(name="questionnaireClaimUse")
        @Extension(url="QuestionnaireClaimUse", definedLocally=false, isModifier=false)
        private CodeType questionnaireClaimUse;
        @Child(name="documentationUrl")
        @Extension(url="DocumentationUrl", definedLocally=false, isModifier=false)
        private UrlType documentationUrl;

        public Reference getQuestionnaire() {
            return this.questionnaire;
        }

        public void setQuestionnaire(Reference questionnaire) {
            this.questionnaire = questionnaire;
        }

        public BooleanType getQuestionnaireRequiredFlag() {
            return this.questionnaireRequiredFlag;
        }

        public void setQuestionnaireRequiredFlag(BooleanType questionnaireRequiredFlag) {
            this.questionnaireRequiredFlag = questionnaireRequiredFlag;
        }

        public CodeType getQuestionnaireClaimUse() {
            return this.questionnaireClaimUse;
        }

        public void setQuestionnaireClaimUse(CodeType questionnaireClaimUse) {
            this.questionnaireClaimUse = questionnaireClaimUse;
        }

        public UrlType getDocumentationUrl() {
            return this.documentationUrl;
        }

        public void setDocumentationUrl(UrlType documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public QuestionnairesExtension copy() {
            QuestionnairesExtension copy = new QuestionnairesExtension();
            copy.documentationUrl = this.documentationUrl;
            copy.questionnaire = this.questionnaire;
            copy.questionnaireClaimUse = this.questionnaireClaimUse;
            copy.questionnaireRequiredFlag = this.questionnaireRequiredFlag;
            return copy;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.questionnaire, this.questionnaireClaimUse, this.questionnaireRequiredFlag, this.documentationUrl});
        }
    }

    @Block
    public static class InformationalMessagesExtension
    extends BackboneElement {
        private static final long serialVersionUID = 4522090347756045147L;
        @Child(name="informationalMessagesCode")
        @Extension(url="InformationalMessagesCode", definedLocally=false, isModifier=false)
        private CodeableConcept informationalMessagesCode;
        @Child(name="informationalMessageCode")
        @Extension(url="InformationalMessageCode", definedLocally=false, isModifier=false)
        private BooleanType informationalMessageCode;
        @Child(name="informationalMessageClaimUse")
        @Extension(url="InformationalMessageClaimUse", definedLocally=false, isModifier=false)
        private CodeType informationalMessageClaimUse;
        @Child(name="documentationUrl")
        @Extension(url="DocumentationUrl", definedLocally=false, isModifier=false)
        private UrlType documentationUrl;

        public CodeableConcept getInformationalMessagesCode() {
            return this.informationalMessagesCode;
        }

        public void setInformationalMessagesCode(CodeableConcept informationalMessagesCode) {
            this.informationalMessagesCode = informationalMessagesCode;
        }

        public BooleanType getInformationalMessageCode() {
            return this.informationalMessageCode;
        }

        public void setInformationalMessageCode(BooleanType informationalMessageCode) {
            this.informationalMessageCode = informationalMessageCode;
        }

        public CodeType getInformationalMessageClaimUse() {
            return this.informationalMessageClaimUse;
        }

        public void setInformationalMessageClaimUse(CodeType informationalMessageClaimUse) {
            this.informationalMessageClaimUse = informationalMessageClaimUse;
        }

        public UrlType getDocumentationUrl() {
            return this.documentationUrl;
        }

        public void setDocumentationUrl(UrlType documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public InformationalMessagesExtension copy() {
            InformationalMessagesExtension copy = new InformationalMessagesExtension();
            copy.documentationUrl = this.documentationUrl;
            copy.informationalMessageClaimUse = this.informationalMessageClaimUse;
            copy.informationalMessagesCode = this.informationalMessagesCode;
            copy.informationalMessageCode = this.informationalMessageCode;
            return copy;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.informationalMessageClaimUse, this.informationalMessageCode, this.informationalMessagesCode, this.documentationUrl});
        }
    }

    @Block
    public static class DiagnosticDocumentsExtension
    extends BackboneElement {
        private static final long serialVersionUID = 4522090347756045146L;
        @Child(name="clinicalDiagnosticDocumentCode")
        @Extension(url="ClinicalDiagnosticDocumentCode", definedLocally=false, isModifier=false)
        private CodeableConcept clinicalDiagnosticDocumentCode;
        @Child(name="clinicalDiagnosticDocumentRequiredFlag")
        @Extension(url="clinicalDiagnosticDocumentRequiredFlag", definedLocally=false, isModifier=false)
        private BooleanType clinicalDiagnosticDocumentRequiredFlag;
        @Child(name="clinicalDiagnosticDocumentMimeType")
        @Extension(url="ClinicalDiagnosticDocumentMimeType", definedLocally=false, isModifier=false)
        private CodeType clinicalDiagnosticDocumentMimeType;
        @Child(name="clinicalDiagnosticDocumentClaimUse")
        @Extension(url="ClinicalDiagnosticDocumentClaimUse", definedLocally=false, isModifier=false)
        private CodeType clinicalDiagnosticDocumentClaimUse;
        @Child(name="documentationUrl")
        @Extension(url="DocumentationUrl", definedLocally=false, isModifier=false)
        private UrlType documentationUrl;

        public CodeableConcept getClinicalDiagnosticDocumentCode() {
            return this.clinicalDiagnosticDocumentCode;
        }

        public void setClinicalDiagnosticDocumentCode(CodeableConcept clinicalDiagnosticDocumentCode) {
            this.clinicalDiagnosticDocumentCode = clinicalDiagnosticDocumentCode;
        }

        public BooleanType getClinicalDiagnosticDocumentRequiredFlag() {
            return this.clinicalDiagnosticDocumentRequiredFlag;
        }

        public void setClinicalDiagnosticDocumentRequiredFlag(BooleanType clinicalDiagnosticDocumentRequiredFlag) {
            this.clinicalDiagnosticDocumentRequiredFlag = clinicalDiagnosticDocumentRequiredFlag;
        }

        public CodeType getClinicalDiagnosticDocumentMimeType() {
            return this.clinicalDiagnosticDocumentMimeType;
        }

        public void setClinicalDiagnosticDocumentMimeType(CodeType clinicalDiagnosticDocumentMimeType) {
            this.clinicalDiagnosticDocumentMimeType = clinicalDiagnosticDocumentMimeType;
        }

        public CodeType getClinicalDiagnosticDocumentClaimUse() {
            return this.clinicalDiagnosticDocumentClaimUse;
        }

        public void setClinicalDiagnosticDocumentClaimUse(CodeType clinicalDiagnosticDocumentClaimUse) {
            this.clinicalDiagnosticDocumentClaimUse = clinicalDiagnosticDocumentClaimUse;
        }

        public UrlType getDocumentationUrl() {
            return this.documentationUrl;
        }

        public void setDocumentationUrl(UrlType documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public DiagnosticDocumentsExtension copy() {
            DiagnosticDocumentsExtension copy = new DiagnosticDocumentsExtension();
            copy.clinicalDiagnosticDocumentCode = this.clinicalDiagnosticDocumentCode;
            copy.clinicalDiagnosticDocumentRequiredFlag = this.clinicalDiagnosticDocumentRequiredFlag;
            copy.clinicalDiagnosticDocumentMimeType = this.clinicalDiagnosticDocumentMimeType;
            copy.clinicalDiagnosticDocumentClaimUse = this.clinicalDiagnosticDocumentClaimUse;
            copy.documentationUrl = this.documentationUrl;
            return copy;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.clinicalDiagnosticDocumentClaimUse, this.clinicalDiagnosticDocumentCode, this.clinicalDiagnosticDocumentMimeType, this.clinicalDiagnosticDocumentRequiredFlag, this.documentationUrl});
        }
    }

    @Block
    public static class PlanBenefitComponent
    extends InsurancePlan.PlanBenefitComponent {
        @Child(name="HCXDiagnosticDocumentsExtension")
        @Extension(url="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXDiagnosticDocumentsExtension.html", definedLocally=false, isModifier=false)
        @Description(shortDefinition="List of documents to be submitted to claim the benefit.")
        protected DiagnosticDocumentsExtension diagnosticDocumentsExtension;
        @Child(name="HCXInformationalMessagesExtension")
        @Extension(url="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXInformationalMessagesExtension.html", definedLocally=false, isModifier=false)
        @Description(shortDefinition="\tMessages related to the benefit.")
        protected InformationalMessagesExtension informationalMessagesExtension;
        @Child(name="HCXQuestionnairesExtension")
        @Extension(url="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXQuestionnairesExtension.html", definedLocally=false, isModifier=false)
        @Description(shortDefinition="Questionnaires to be answered to claim the benefit.")
        protected QuestionnairesExtension questionnairesExtension;

        public DiagnosticDocumentsExtension getDiagnosticDocumentsExtension() {
            return this.diagnosticDocumentsExtension;
        }

        public void setDiagnosticDocumentsExtension(DiagnosticDocumentsExtension diagnosticDocumentsExtension) {
            this.diagnosticDocumentsExtension = diagnosticDocumentsExtension;
        }

        public InformationalMessagesExtension getInformationalMessagesExtension() {
            return this.informationalMessagesExtension;
        }

        public void setInformationalMessagesExtension(InformationalMessagesExtension informationalMessagesExtension) {
            this.informationalMessagesExtension = informationalMessagesExtension;
        }

        public QuestionnairesExtension getQuestionnairesExtension() {
            return this.questionnairesExtension;
        }

        public void setQuestionnairesExtension(QuestionnairesExtension questionnairesExtension) {
            this.questionnairesExtension = questionnairesExtension;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.informationalMessagesExtension, this.questionnairesExtension, this.diagnosticDocumentsExtension});
        }
    }

    @Block
    public static class PresenceExtension
    extends BackboneElement {
        private static final long serialVersionUID = 4522090347756045146L;
        @Child(name="proofOfPresenceDocumentCode")
        @Extension(url="ProofOfPresenceDocumentCode", definedLocally=false, isModifier=false)
        private CodeableConcept proofOfPresenceDocumentCode;
        @Child(name="proofOfPresenceDocumentRequiredFlag")
        @Extension(url="ProofOfPresenceDocumentRequiredFlag", definedLocally=false, isModifier=false)
        private BooleanType proofOfPresenceDocumentRequiredFlag;
        @Child(name="proofOfPresenceDocumentMimeType")
        @Extension(url="ProofOfPresenceDocumentMimeType", definedLocally=false, isModifier=false)
        private CodeType proofOfPresenceDocumentMimeType;
        @Child(name="clinicalDiagnosticDocumentClaimUse")
        @Extension(url="ClinicalDiagnosticDocumentClaimUse", definedLocally=false, isModifier=false)
        private CodeType clinicalDiagnosticDocumentClaimUse;
        @Child(name="documentationUrl")
        @Extension(url="DocumentationUrl", definedLocally=false, isModifier=false)
        private UrlType documentationUrl;

        public PresenceExtension() {
            this.setDocumentationUrl(new UrlType("http://documentation-url"));
        }

        public CodeableConcept getProofOfPresenceDocumentCode() {
            return this.proofOfPresenceDocumentCode;
        }

        public void setProofOfPresenceDocumentCode(CodeableConcept proofOfPresenceDocumentCode) {
            this.proofOfPresenceDocumentCode = proofOfPresenceDocumentCode;
        }

        public BooleanType isProofOfPresenceDocumentRequiredFlag() {
            return this.proofOfPresenceDocumentRequiredFlag;
        }

        public void setProofOfPresenceDocumentRequiredFlag(BooleanType proofOfPresenceDocumentRequiredFlag) {
            this.proofOfPresenceDocumentRequiredFlag = proofOfPresenceDocumentRequiredFlag;
        }

        public CodeType getProofOfPresenceDocumentMimeType() {
            return this.proofOfPresenceDocumentMimeType;
        }

        public void setProofOfPresenceDocumentMimeType(CodeType proofOfPresenceDocumentMimeType) {
            this.proofOfPresenceDocumentMimeType = proofOfPresenceDocumentMimeType;
        }

        public CodeType getClinicalDiagnosticDocumentClaimUse() {
            return this.clinicalDiagnosticDocumentClaimUse;
        }

        public void setClinicalDiagnosticDocumentClaimUse(CodeType clinicalDiagnosticDocumentClaimUse) {
            this.clinicalDiagnosticDocumentClaimUse = clinicalDiagnosticDocumentClaimUse;
        }

        public UrlType getDocumentationUrl() {
            return this.documentationUrl;
        }

        public void setDocumentationUrl(UrlType documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public void setClinicalDiagnosticDocumentClaimUse(String claimUseCode) {
            this.setClinicalDiagnosticDocumentClaimUse(new CodeType(claimUseCode));
        }

        public void setProofOfPresenceDocumentCode(String code, String display) {
            this.setProofOfPresenceDocumentCode(new CodeableConcept(new Coding().setSystem("https://hcx-valuesets/proofOfIdentificationDocumentCodes").setCode(code).setDisplay(display).setVersion("1.0.0")));
        }

        public PresenceExtension copy() {
            PresenceExtension copy = new PresenceExtension();
            copy.clinicalDiagnosticDocumentClaimUse = this.clinicalDiagnosticDocumentClaimUse;
            copy.proofOfPresenceDocumentCode = this.proofOfPresenceDocumentCode;
            copy.proofOfPresenceDocumentMimeType = this.proofOfPresenceDocumentMimeType;
            copy.proofOfPresenceDocumentRequiredFlag = this.proofOfPresenceDocumentRequiredFlag;
            copy.documentationUrl = this.documentationUrl;
            return copy;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.clinicalDiagnosticDocumentClaimUse, this.proofOfPresenceDocumentCode, this.proofOfPresenceDocumentMimeType, this.proofOfPresenceDocumentRequiredFlag, this.documentationUrl});
        }
    }

    @Block
    public static class IdentificationExtension
    extends BackboneElement {
        private static final long serialVersionUID = 4522090347756045145L;
        @Child(name="proofOfIdDocumentCode")
        @Extension(url="ProofOfIdentificationDocumentCode", definedLocally=false, isModifier=false)
        private CodeableConcept proofOfIdDocumentCode;
        @Child(name="proofOfIdentificationDocumentRequiredFlag")
        @Extension(url="ProofOfIdentificationDocumentRequiredFlag", definedLocally=false, isModifier=false)
        private BooleanType proofOfIdentificationDocumentRequiredFlag;
        @Child(name="proofOfIdentificationDocumentMimeType")
        @Extension(url="ProofOfIdentificationDocumentMimeType", definedLocally=false, isModifier=false)
        private CodeType proofOfIdentificationDocumentMimeType;
        @Child(name="clinicalDiagnosticDocumentClaimUse")
        @Extension(url="ClinicalDiagnosticDocumentClaimUse", definedLocally=false, isModifier=false)
        private CodeType clinicalDiagnosticDocumentClaimUse;
        @Child(name="documentationUrl")
        @Extension(url="DocumentationUrl", definedLocally=false, isModifier=false)
        private UrlType documentationUrl;

        public IdentificationExtension() {
            this.setDocumentationUrl(new UrlType("http://documentation-url"));
        }

        public CodeableConcept getProofOfIdDocumentCode() {
            return this.proofOfIdDocumentCode;
        }

        public void setProofOfIdDocumentCode(CodeableConcept proofOfIdDocumentCode) {
            this.proofOfIdDocumentCode = proofOfIdDocumentCode;
        }

        public BooleanType isProofOfIdentificationDocumentRequiredFlag() {
            return this.proofOfIdentificationDocumentRequiredFlag;
        }

        public void setProofOfIdentificationDocumentRequiredFlag(BooleanType proofOfIdentificationDocumentRequiredFlag) {
            this.proofOfIdentificationDocumentRequiredFlag = proofOfIdentificationDocumentRequiredFlag;
        }

        public CodeType getProofOfIdentificationDocumentMimeType() {
            return this.proofOfIdentificationDocumentMimeType;
        }

        public void setProofOfIdentificationDocumentMimeType(CodeType proofOfIdentificationDocumentMimeType) {
            this.proofOfIdentificationDocumentMimeType = proofOfIdentificationDocumentMimeType;
        }

        public CodeType getClinicalDiagnosticDocumentClaimUse() {
            return this.clinicalDiagnosticDocumentClaimUse;
        }

        public void setClinicalDiagnosticDocumentClaimUse(CodeType clinicalDiagnosticDocumentClaimUse) {
            this.clinicalDiagnosticDocumentClaimUse = clinicalDiagnosticDocumentClaimUse;
        }

        public UrlType getDocumentationUrl() {
            return this.documentationUrl;
        }

        public void setDocumentationUrl(UrlType documentationUrl) {
            this.documentationUrl = documentationUrl;
        }

        public void setProofOfIdDocumentCode(String code, String display) {
            this.setProofOfIdDocumentCode(new CodeableConcept(new Coding().setSystem("https://hcx-valuesets/proofOfIdentificationDocumentCodes").setCode(code).setDisplay(display).setVersion("1.0.0")));
        }

        public void setClinicalDiagnosticDocumentClaimUse(String claimUseCode) {
            this.setClinicalDiagnosticDocumentClaimUse(new CodeType(claimUseCode));
        }

        public IdentificationExtension copy() {
            IdentificationExtension copy = new IdentificationExtension();
            copy.clinicalDiagnosticDocumentClaimUse = this.clinicalDiagnosticDocumentClaimUse;
            copy.proofOfIdentificationDocumentMimeType = this.proofOfIdentificationDocumentMimeType;
            copy.proofOfIdentificationDocumentRequiredFlag = this.proofOfIdentificationDocumentRequiredFlag;
            copy.proofOfIdDocumentCode = this.proofOfIdDocumentCode;
            copy.documentationUrl = this.documentationUrl;
            return copy;
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.clinicalDiagnosticDocumentClaimUse, this.proofOfIdDocumentCode, this.proofOfIdentificationDocumentMimeType, this.proofOfIdentificationDocumentRequiredFlag, this.documentationUrl});
        }
    }

    @Block
    public static class InsurancePlanPlanComponent
    extends InsurancePlan.InsurancePlanPlanComponent {
        @Child(name="HCXProofOfIdentificationExtension")
        @Extension(url="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXProofOfIdentificationExtension.html", definedLocally=false, isModifier=false)
        @Description(shortDefinition="Adding Proof of Identification as extension to base InsuracncePlan SD")
        protected IdentificationExtension identificationExtension;
        @Child(name="HCXProofOfPresenceExtension")
        @Extension(url="https://ig.hcxprotocol.io/v0.7/StructureDefinition-HCXProofOfPresenceExtension.html", definedLocally=false, isModifier=false)
        @Description(shortDefinition="Adding Proof of Presence as extension to base InsuracncePlan SD")
        protected PresenceExtension presenceExtension;

        public InsurancePlanPlanComponent() {
            this.setId(UUID.randomUUID().toString());
        }

        public IdentificationExtension getIdentificationExtension() {
            return this.identificationExtension;
        }

        public void setIdentificationExtension(IdentificationExtension identificationExtension) {
            this.identificationExtension = identificationExtension;
        }

        public PresenceExtension getPresenceExtension() {
            return this.presenceExtension;
        }

        public void setPresenceExtension(PresenceExtension presenceExtension) {
            this.presenceExtension = presenceExtension;
        }

        public void setType(String code) {
            this.setType(new CodeableConcept().setCoding(Collections.singletonList(new Coding().setCode(code).setSystem("http://terminologyServer/ValueSets/plan-type"))));
        }

        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identificationExtension, this.presenceExtension});
        }
    }
}

