/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.model.VersionModel;
import io.gs2.version.request.GetVersionModelRequest;
import io.gs2.version.result.GetVersionModelResult;

public class VersionModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final String versionName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public VersionModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String versionName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.versionName = versionName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "VersionModel");
    }

    private VersionModel get(GetVersionModelRequest request) {
        request.withNamespaceName(this.namespaceName).withVersionName(this.versionName);
        GetVersionModelResult result = this.client.getVersionModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, VersionModelDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String versionName, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, versionName, childType);
    }

    public static String createCacheKey(String versionName) {
        return String.join((CharSequence)":", versionName);
    }

    public VersionModel model() {
        VersionModel value = this.cache.get(this.parentKey, VersionModelDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModel.class);
        if (value == null) {
            try {
                this.get(new GetVersionModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, VersionModelDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModel.class);
            }
            value = this.cache.get(this.parentKey, VersionModelDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), VersionModel.class);
        }
        return value;
    }
}

