/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.model.CurrentVersionMaster;
import io.gs2.version.request.ExportMasterRequest;
import io.gs2.version.request.GetCurrentVersionMasterRequest;
import io.gs2.version.request.UpdateCurrentVersionMasterFromGitHubRequest;
import io.gs2.version.request.UpdateCurrentVersionMasterRequest;
import io.gs2.version.result.ExportMasterResult;
import io.gs2.version.result.GetCurrentVersionMasterResult;
import io.gs2.version.result.UpdateCurrentVersionMasterFromGitHubResult;
import io.gs2.version.result.UpdateCurrentVersionMasterResult;

public class CurrentVersionMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentVersionMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentVersionMaster");
    }

    public CurrentVersionMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentVersionMasterDomain domain = this;
        return domain;
    }

    private CurrentVersionMaster get(GetCurrentVersionMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentVersionMasterResult result = this.client.getCurrentVersionMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentVersionMasterDomain update(UpdateCurrentVersionMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentVersionMasterResult result = this.client.updateCurrentVersionMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentVersionMasterDomain domain = this;
        return domain;
    }

    public CurrentVersionMasterDomain updateFromGitHub(UpdateCurrentVersionMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentVersionMasterFromGitHubResult result = this.client.updateCurrentVersionMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentVersionMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public CurrentVersionMaster model() {
        CurrentVersionMaster value = this.cache.get(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), CurrentVersionMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentVersionMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), CurrentVersionMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentVersionMasterDomain.createCacheKey(), CurrentVersionMaster.class);
        }
        return value;
    }
}

