/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.UserDomain;
import io.gs2.version.model.Status;
import io.gs2.version.request.CheckVersionRequest;
import io.gs2.version.result.CheckVersionResult;
import java.util.List;

public class CheckerAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String projectToken;
    List<Status> warnings;
    List<Status> errors;
    String body;
    String signature;

    public String getProjectToken() {
        return this.projectToken;
    }

    public List<Status> getWarnings() {
        return this.warnings;
    }

    public List<Status> getErrors() {
        return this.errors;
    }

    public String getBody() {
        return this.body;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public CheckerAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Checker");
    }

    public CheckerAccessTokenDomain checkVersion(CheckVersionRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        CheckVersionResult result = this.client.checkVersion(request);
        CheckerAccessTokenDomain domain = this;
        this.projectToken = result.getProjectToken();
        this.warnings = result.getWarnings();
        this.errors = result.getErrors();
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }
}

