/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.AcceptVersionDomain;
import io.gs2.version.domain.model.UserDomain;
import io.gs2.version.model.AcceptVersion;
import io.gs2.version.request.AcceptRequest;
import io.gs2.version.request.DeleteAcceptVersionRequest;
import io.gs2.version.request.GetAcceptVersionRequest;
import io.gs2.version.result.AcceptResult;
import io.gs2.version.result.DeleteAcceptVersionResult;
import io.gs2.version.result.GetAcceptVersionResult;

public class AcceptVersionAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2VersionRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String versionName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getVersionName() {
        return this.versionName;
    }

    public AcceptVersionAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String versionName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2VersionRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.versionName = versionName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "AcceptVersion");
    }

    public AcceptVersionAccessTokenDomain accept(AcceptRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withVersionName(this.versionName);
        AcceptResult result = this.client.accept(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        AcceptVersionAccessTokenDomain domain = this;
        return domain;
    }

    private AcceptVersion get(GetAcceptVersionRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withVersionName(this.versionName);
        GetAcceptVersionResult result = this.client.getAcceptVersion(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public AcceptVersionAccessTokenDomain delete(DeleteAcceptVersionRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withVersionName(this.versionName);
        DeleteAcceptVersionResult result = null;
        try {
            result = this.client.deleteAcceptVersion(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, AcceptVersionDomain.createCacheKey(request.getVersionName() != null ? request.getVersionName().toString() : null), AcceptVersion.class);
        AcceptVersionAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String versionName, String childType) {
        return String.join((CharSequence)":", "version", namespaceName, userId, versionName, childType);
    }

    public static String createCacheKey(String versionName) {
        return String.join((CharSequence)":", versionName);
    }

    public AcceptVersion model() {
        AcceptVersion value = this.cache.get(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
        if (value == null) {
            try {
                this.get(new GetAcceptVersionRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
            }
            value = this.cache.get(this.parentKey, AcceptVersionDomain.createCacheKey(this.getVersionName() != null ? this.getVersionName().toString() : null), AcceptVersion.class);
        }
        return value;
    }
}

