/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.domain.model.VersionModelDomain;
import io.gs2.version.model.VersionModel;
import io.gs2.version.request.DescribeVersionModelsRequest;
import io.gs2.version.result.DescribeVersionModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeVersionModelsIterator
implements Iterator<VersionModel>,
Iterable<VersionModel> {
    CacheDatabase cache;
    Gs2VersionRestClient client;
    String namespaceName;
    boolean last;
    List<VersionModel> result;
    Integer fetchSize;

    public DescribeVersionModelsIterator(CacheDatabase cache, Gs2VersionRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<VersionModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "VersionModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, VersionModel.class)) {
            this.result = this.cache.list(parentKey, VersionModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeVersionModelsResult r = this.client.describeVersionModels(new DescribeVersionModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (VersionModel item : this.result) {
                this.cache.put(parentKey, VersionModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, VersionModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public VersionModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        VersionModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<VersionModel> iterator() {
        return this;
    }
}

