/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.NamespaceDomain;
import io.gs2.version.domain.model.VersionModelMasterDomain;
import io.gs2.version.model.VersionModelMaster;
import io.gs2.version.request.DescribeVersionModelMastersRequest;
import io.gs2.version.result.DescribeVersionModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeVersionModelMastersIterator
implements Iterator<VersionModelMaster>,
Iterable<VersionModelMaster> {
    CacheDatabase cache;
    Gs2VersionRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<VersionModelMaster> result;
    Integer fetchSize;

    public DescribeVersionModelMastersIterator(CacheDatabase cache, Gs2VersionRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<VersionModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "VersionModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, VersionModelMaster.class)) {
            this.result = this.cache.list(parentKey, VersionModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeVersionModelMastersResult r = this.client.describeVersionModelMasters(new DescribeVersionModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (VersionModelMaster item : this.result) {
                this.cache.put(parentKey, VersionModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, VersionModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public VersionModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        VersionModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<VersionModelMaster> iterator() {
        return this;
    }
}

