/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.version.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.version.Gs2VersionRestClient;
import io.gs2.version.domain.model.AcceptVersionDomain;
import io.gs2.version.domain.model.UserDomain;
import io.gs2.version.model.AcceptVersion;
import io.gs2.version.request.DescribeAcceptVersionsByUserIdRequest;
import io.gs2.version.result.DescribeAcceptVersionsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeAcceptVersionsByUserIdIterator
implements Iterator<AcceptVersion>,
Iterable<AcceptVersion> {
    CacheDatabase cache;
    Gs2VersionRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<AcceptVersion> result;
    Integer fetchSize;

    public DescribeAcceptVersionsByUserIdIterator(CacheDatabase cache, Gs2VersionRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<AcceptVersion>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "AcceptVersion");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, AcceptVersion.class)) {
            this.result = this.cache.list(parentKey, AcceptVersion.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeAcceptVersionsByUserIdResult r = this.client.describeAcceptVersionsByUserId(new DescribeAcceptVersionsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (AcceptVersion item : this.result) {
                this.cache.put(parentKey, AcceptVersionDomain.createCacheKey(item.getVersionName() != null ? item.getVersionName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, AcceptVersion.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public AcceptVersion next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        AcceptVersion ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<AcceptVersion> iterator() {
        return this;
    }
}

