/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.StaminaModelMaster;
import io.gs2.stamina.request.DeleteStaminaModelMasterRequest;
import io.gs2.stamina.request.GetStaminaModelMasterRequest;
import io.gs2.stamina.request.UpdateStaminaModelMasterRequest;
import io.gs2.stamina.result.DeleteStaminaModelMasterResult;
import io.gs2.stamina.result.GetStaminaModelMasterResult;
import io.gs2.stamina.result.UpdateStaminaModelMasterResult;

public class StaminaModelMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String staminaName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getStaminaName() {
        return this.staminaName;
    }

    public StaminaModelMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String staminaName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.staminaName = staminaName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "StaminaModelMaster");
    }

    private StaminaModelMaster get(GetStaminaModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withStaminaName(this.staminaName);
        GetStaminaModelMasterResult result = this.client.getStaminaModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaModelMasterDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StaminaModelMasterDomain update(UpdateStaminaModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withStaminaName(this.staminaName);
        UpdateStaminaModelMasterResult result = this.client.updateStaminaModelMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaModelMasterDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaModelMasterDomain domain = this;
        return domain;
    }

    public StaminaModelMasterDomain delete(DeleteStaminaModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withStaminaName(this.staminaName);
        DeleteStaminaModelMasterResult result = null;
        try {
            result = this.client.deleteStaminaModelMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, StaminaModelMasterDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), StaminaModelMaster.class);
        StaminaModelMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String staminaName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, staminaName, childType);
    }

    public static String createCacheKey(String staminaName) {
        return String.join((CharSequence)":", staminaName);
    }

    public StaminaModelMaster model() {
        StaminaModelMaster value = this.cache.get(this.parentKey, StaminaModelMasterDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), StaminaModelMaster.class);
        if (value == null) {
            try {
                this.get(new GetStaminaModelMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, StaminaModelMasterDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), StaminaModelMaster.class);
            }
            value = this.cache.get(this.parentKey, StaminaModelMasterDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), StaminaModelMaster.class);
        }
        return value;
    }
}

