/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.StaminaModelDomain;
import io.gs2.stamina.domain.model.UserDomain;
import io.gs2.stamina.model.Stamina;
import io.gs2.stamina.request.ConsumeStaminaByUserIdRequest;
import io.gs2.stamina.request.DeleteStaminaByUserIdRequest;
import io.gs2.stamina.request.GetStaminaByUserIdRequest;
import io.gs2.stamina.request.RaiseMaxValueByUserIdRequest;
import io.gs2.stamina.request.RecoverStaminaByUserIdRequest;
import io.gs2.stamina.request.SetMaxValueByUserIdRequest;
import io.gs2.stamina.request.SetRecoverIntervalByUserIdRequest;
import io.gs2.stamina.request.SetRecoverValueByUserIdRequest;
import io.gs2.stamina.request.UpdateStaminaByUserIdRequest;
import io.gs2.stamina.result.ConsumeStaminaByUserIdResult;
import io.gs2.stamina.result.DeleteStaminaByUserIdResult;
import io.gs2.stamina.result.GetStaminaByUserIdResult;
import io.gs2.stamina.result.RaiseMaxValueByUserIdResult;
import io.gs2.stamina.result.RecoverStaminaByUserIdResult;
import io.gs2.stamina.result.SetMaxValueByUserIdResult;
import io.gs2.stamina.result.SetRecoverIntervalByUserIdResult;
import io.gs2.stamina.result.SetRecoverValueByUserIdResult;
import io.gs2.stamina.result.UpdateStaminaByUserIdResult;

public class StaminaDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String staminaName;
    private final String parentKey;
    Long overflowValue;

    public Long getOverflowValue() {
        return this.overflowValue;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getStaminaName() {
        return this.staminaName;
    }

    public StaminaDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String staminaName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.staminaName = staminaName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Stamina");
    }

    private Stamina get(GetStaminaByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        GetStaminaByUserIdResult result = this.client.getStaminaByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StaminaDomain update(UpdateStaminaByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        UpdateStaminaByUserIdResult result = this.client.updateStaminaByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain consume(ConsumeStaminaByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        ConsumeStaminaByUserIdResult result = this.client.consumeStaminaByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain recover(RecoverStaminaByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        RecoverStaminaByUserIdResult result = this.client.recoverStaminaByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        domain.overflowValue = result.getOverflowValue();
        return domain;
    }

    public StaminaDomain raiseMaxValue(RaiseMaxValueByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        RaiseMaxValueByUserIdResult result = this.client.raiseMaxValueByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain setMaxValue(SetMaxValueByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        SetMaxValueByUserIdResult result = this.client.setMaxValueByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain setRecoverInterval(SetRecoverIntervalByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        SetRecoverIntervalByUserIdResult result = this.client.setRecoverIntervalByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain setRecoverValue(SetRecoverValueByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        SetRecoverValueByUserIdResult result = this.client.setRecoverValueByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaDomain domain = this;
        return domain;
    }

    public StaminaDomain delete(DeleteStaminaByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withStaminaName(this.staminaName);
        DeleteStaminaByUserIdResult result = null;
        try {
            result = this.client.deleteStaminaByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), Stamina.class);
        StaminaDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String staminaName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, userId, staminaName, childType);
    }

    public static String createCacheKey(String staminaName) {
        return String.join((CharSequence)":", staminaName);
    }

    public Stamina model() {
        Stamina value = this.cache.get(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
        if (value == null) {
            try {
                this.get(new GetStaminaByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
            }
            value = this.cache.get(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
        }
        return value;
    }
}

