/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.StaminaDomain;
import io.gs2.stamina.domain.model.StaminaModelDomain;
import io.gs2.stamina.domain.model.UserDomain;
import io.gs2.stamina.model.Stamina;
import io.gs2.stamina.request.ConsumeStaminaRequest;
import io.gs2.stamina.request.GetStaminaRequest;
import io.gs2.stamina.request.SetMaxValueByStatusRequest;
import io.gs2.stamina.request.SetRecoverIntervalByStatusRequest;
import io.gs2.stamina.request.SetRecoverValueByStatusRequest;
import io.gs2.stamina.result.ConsumeStaminaResult;
import io.gs2.stamina.result.GetStaminaResult;
import io.gs2.stamina.result.SetMaxValueByStatusResult;
import io.gs2.stamina.result.SetRecoverIntervalByStatusResult;
import io.gs2.stamina.result.SetRecoverValueByStatusResult;

public class StaminaAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String staminaName;
    private final String parentKey;
    Long overflowValue;

    public Long getOverflowValue() {
        return this.overflowValue;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getStaminaName() {
        return this.staminaName;
    }

    public StaminaAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String staminaName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.staminaName = staminaName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Stamina");
    }

    private Stamina get(GetStaminaRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStaminaName(this.staminaName);
        GetStaminaResult result = this.client.getStamina(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StaminaAccessTokenDomain consume(ConsumeStaminaRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStaminaName(this.staminaName);
        ConsumeStaminaResult result = this.client.consumeStamina(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaAccessTokenDomain domain = this;
        return domain;
    }

    public StaminaAccessTokenDomain setMaxValueByStatus(SetMaxValueByStatusRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStaminaName(this.staminaName);
        SetMaxValueByStatusResult result = this.client.setMaxValueByStatus(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaAccessTokenDomain domain = this;
        return domain;
    }

    public StaminaAccessTokenDomain setRecoverIntervalByStatus(SetRecoverIntervalByStatusRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStaminaName(this.staminaName);
        SetRecoverIntervalByStatusResult result = this.client.setRecoverIntervalByStatus(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaAccessTokenDomain domain = this;
        return domain;
    }

    public StaminaAccessTokenDomain setRecoverValueByStatus(SetRecoverValueByStatusRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withStaminaName(this.staminaName);
        SetRecoverValueByStatusResult result = this.client.setRecoverValueByStatus(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, StaminaDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getStaminaModel() != null) {
            this.cache.put(this.parentKey, StaminaModelDomain.createCacheKey(request.getStaminaName() != null ? request.getStaminaName().toString() : null), result.getStaminaModel(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String staminaName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, userId, staminaName, childType);
    }

    public static String createCacheKey(String staminaName) {
        return String.join((CharSequence)":", staminaName);
    }

    public Stamina model() {
        Stamina value = this.cache.get(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
        if (value == null) {
            try {
                this.get(new GetStaminaRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
            }
            value = this.cache.get(this.parentKey, StaminaDomain.createCacheKey(this.getStaminaName() != null ? this.getStaminaName().toString() : null), Stamina.class);
        }
        return value;
    }
}

