/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.iterator.DescribeMaxStaminaTableMastersIterator;
import io.gs2.stamina.domain.iterator.DescribeRecoverIntervalTableMastersIterator;
import io.gs2.stamina.domain.iterator.DescribeRecoverValueTableMastersIterator;
import io.gs2.stamina.domain.iterator.DescribeStaminaModelMastersIterator;
import io.gs2.stamina.domain.iterator.DescribeStaminaModelsIterator;
import io.gs2.stamina.domain.model.CurrentStaminaMasterDomain;
import io.gs2.stamina.domain.model.MaxStaminaTableDomain;
import io.gs2.stamina.domain.model.MaxStaminaTableMasterDomain;
import io.gs2.stamina.domain.model.RecoverIntervalTableDomain;
import io.gs2.stamina.domain.model.RecoverIntervalTableMasterDomain;
import io.gs2.stamina.domain.model.RecoverValueTableDomain;
import io.gs2.stamina.domain.model.RecoverValueTableMasterDomain;
import io.gs2.stamina.domain.model.StaminaModelDomain;
import io.gs2.stamina.domain.model.StaminaModelMasterDomain;
import io.gs2.stamina.domain.model.UserAccessTokenDomain;
import io.gs2.stamina.domain.model.UserDomain;
import io.gs2.stamina.model.Namespace;
import io.gs2.stamina.request.CreateMaxStaminaTableMasterRequest;
import io.gs2.stamina.request.CreateRecoverIntervalTableMasterRequest;
import io.gs2.stamina.request.CreateRecoverValueTableMasterRequest;
import io.gs2.stamina.request.CreateStaminaModelMasterRequest;
import io.gs2.stamina.request.DeleteNamespaceRequest;
import io.gs2.stamina.request.GetNamespaceRequest;
import io.gs2.stamina.request.GetNamespaceStatusRequest;
import io.gs2.stamina.request.UpdateNamespaceRequest;
import io.gs2.stamina.result.CreateMaxStaminaTableMasterResult;
import io.gs2.stamina.result.CreateRecoverIntervalTableMasterResult;
import io.gs2.stamina.result.CreateRecoverValueTableMasterResult;
import io.gs2.stamina.result.CreateStaminaModelMasterResult;
import io.gs2.stamina.result.DeleteNamespaceResult;
import io.gs2.stamina.result.GetNamespaceResult;
import io.gs2.stamina.result.GetNamespaceStatusResult;
import io.gs2.stamina.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "stamina:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public RecoverIntervalTableMasterDomain createRecoverIntervalTableMaster(CreateRecoverIntervalTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateRecoverIntervalTableMasterResult result = this.client.createRecoverIntervalTableMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverIntervalTableMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, RecoverIntervalTableMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RecoverIntervalTableMasterDomain domain = new RecoverIntervalTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public MaxStaminaTableMasterDomain createMaxStaminaTableMaster(CreateMaxStaminaTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateMaxStaminaTableMasterResult result = this.client.createMaxStaminaTableMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MaxStaminaTableMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, MaxStaminaTableMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MaxStaminaTableMasterDomain domain = new MaxStaminaTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public RecoverValueTableMasterDomain createRecoverValueTableMaster(CreateRecoverValueTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateRecoverValueTableMasterResult result = this.client.createRecoverValueTableMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "RecoverValueTableMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, RecoverValueTableMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        RecoverValueTableMasterDomain domain = new RecoverValueTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public StaminaModelMasterDomain createStaminaModelMaster(CreateStaminaModelMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateStaminaModelMasterResult result = this.client.createStaminaModelMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "StaminaModelMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, StaminaModelMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StaminaModelMasterDomain domain = new StaminaModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentStaminaMasterDomain currentStaminaMaster() {
        return new CurrentStaminaMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public MaxStaminaTableDomain maxStaminaTable(String maxStaminaTableName) {
        return new MaxStaminaTableDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, maxStaminaTableName);
    }

    public RecoverIntervalTableDomain recoverIntervalTable(String recoverIntervalTableName) {
        return new RecoverIntervalTableDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, recoverIntervalTableName);
    }

    public RecoverValueTableDomain recoverValueTable(String recoverValueTableName) {
        return new RecoverValueTableDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, recoverValueTableName);
    }

    public DescribeStaminaModelsIterator staminaModels() {
        return new DescribeStaminaModelsIterator(this.cache, this.client, this.namespaceName);
    }

    public StaminaModelDomain staminaModel(String staminaName) {
        return new StaminaModelDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, staminaName);
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public DescribeRecoverIntervalTableMastersIterator recoverIntervalTableMasters() {
        return new DescribeRecoverIntervalTableMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public RecoverIntervalTableMasterDomain recoverIntervalTableMaster(String recoverIntervalTableName) {
        return new RecoverIntervalTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, recoverIntervalTableName);
    }

    public DescribeMaxStaminaTableMastersIterator maxStaminaTableMasters() {
        return new DescribeMaxStaminaTableMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public MaxStaminaTableMasterDomain maxStaminaTableMaster(String maxStaminaTableName) {
        return new MaxStaminaTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, maxStaminaTableName);
    }

    public DescribeRecoverValueTableMastersIterator recoverValueTableMasters() {
        return new DescribeRecoverValueTableMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public RecoverValueTableMasterDomain recoverValueTableMaster(String recoverValueTableName) {
        return new RecoverValueTableMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, recoverValueTableName);
    }

    public DescribeStaminaModelMastersIterator staminaModelMasters() {
        return new DescribeStaminaModelMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public StaminaModelMasterDomain staminaModelMaster(String staminaName) {
        return new StaminaModelMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, staminaName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

