/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.MaxStaminaTableMaster;
import io.gs2.stamina.request.DeleteMaxStaminaTableMasterRequest;
import io.gs2.stamina.request.GetMaxStaminaTableMasterRequest;
import io.gs2.stamina.request.UpdateMaxStaminaTableMasterRequest;
import io.gs2.stamina.result.DeleteMaxStaminaTableMasterResult;
import io.gs2.stamina.result.GetMaxStaminaTableMasterResult;
import io.gs2.stamina.result.UpdateMaxStaminaTableMasterResult;

public class MaxStaminaTableMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2StaminaRestClient client;
    private final String namespaceName;
    private final String maxStaminaTableName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getMaxStaminaTableName() {
        return this.maxStaminaTableName;
    }

    public MaxStaminaTableMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String maxStaminaTableName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2StaminaRestClient(session);
        this.namespaceName = namespaceName;
        this.maxStaminaTableName = maxStaminaTableName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MaxStaminaTableMaster");
    }

    private MaxStaminaTableMaster get(GetMaxStaminaTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMaxStaminaTableName(this.maxStaminaTableName);
        GetMaxStaminaTableMasterResult result = this.client.getMaxStaminaTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(request.getMaxStaminaTableName() != null ? request.getMaxStaminaTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public MaxStaminaTableMasterDomain update(UpdateMaxStaminaTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMaxStaminaTableName(this.maxStaminaTableName);
        UpdateMaxStaminaTableMasterResult result = this.client.updateMaxStaminaTableMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(request.getMaxStaminaTableName() != null ? request.getMaxStaminaTableName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        MaxStaminaTableMasterDomain domain = this;
        return domain;
    }

    public MaxStaminaTableMasterDomain delete(DeleteMaxStaminaTableMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withMaxStaminaTableName(this.maxStaminaTableName);
        DeleteMaxStaminaTableMasterResult result = null;
        try {
            result = this.client.deleteMaxStaminaTableMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(request.getMaxStaminaTableName() != null ? request.getMaxStaminaTableName().toString() : null), MaxStaminaTableMaster.class);
        MaxStaminaTableMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String maxStaminaTableName, String childType) {
        return String.join((CharSequence)":", "stamina", namespaceName, maxStaminaTableName, childType);
    }

    public static String createCacheKey(String maxStaminaTableName) {
        return String.join((CharSequence)":", maxStaminaTableName);
    }

    public MaxStaminaTableMaster model() {
        MaxStaminaTableMaster value = this.cache.get(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(this.getMaxStaminaTableName() != null ? this.getMaxStaminaTableName().toString() : null), MaxStaminaTableMaster.class);
        if (value == null) {
            try {
                this.get(new GetMaxStaminaTableMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(this.getMaxStaminaTableName() != null ? this.getMaxStaminaTableName().toString() : null), MaxStaminaTableMaster.class);
            }
            value = this.cache.get(this.parentKey, MaxStaminaTableMasterDomain.createCacheKey(this.getMaxStaminaTableName() != null ? this.getMaxStaminaTableName().toString() : null), MaxStaminaTableMaster.class);
        }
        return value;
    }
}

