/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.domain.model.StaminaModelMasterDomain;
import io.gs2.stamina.model.StaminaModelMaster;
import io.gs2.stamina.request.DescribeStaminaModelMastersRequest;
import io.gs2.stamina.result.DescribeStaminaModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeStaminaModelMastersIterator
implements Iterator<StaminaModelMaster>,
Iterable<StaminaModelMaster> {
    CacheDatabase cache;
    Gs2StaminaRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<StaminaModelMaster> result;
    Integer fetchSize;

    public DescribeStaminaModelMastersIterator(CacheDatabase cache, Gs2StaminaRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<StaminaModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "StaminaModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, StaminaModelMaster.class)) {
            this.result = this.cache.list(parentKey, StaminaModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeStaminaModelMastersResult r = this.client.describeStaminaModelMasters(new DescribeStaminaModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (StaminaModelMaster item : this.result) {
                this.cache.put(parentKey, StaminaModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, StaminaModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public StaminaModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        StaminaModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<StaminaModelMaster> iterator() {
        return this;
    }
}

