/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.stamina.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.stamina.Gs2StaminaRestClient;
import io.gs2.stamina.domain.model.MaxStaminaTableMasterDomain;
import io.gs2.stamina.domain.model.NamespaceDomain;
import io.gs2.stamina.model.MaxStaminaTableMaster;
import io.gs2.stamina.request.DescribeMaxStaminaTableMastersRequest;
import io.gs2.stamina.result.DescribeMaxStaminaTableMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeMaxStaminaTableMastersIterator
implements Iterator<MaxStaminaTableMaster>,
Iterable<MaxStaminaTableMaster> {
    CacheDatabase cache;
    Gs2StaminaRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<MaxStaminaTableMaster> result;
    Integer fetchSize;

    public DescribeMaxStaminaTableMastersIterator(CacheDatabase cache, Gs2StaminaRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<MaxStaminaTableMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "MaxStaminaTableMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, MaxStaminaTableMaster.class)) {
            this.result = this.cache.list(parentKey, MaxStaminaTableMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeMaxStaminaTableMastersResult r = this.client.describeMaxStaminaTableMasters(new DescribeMaxStaminaTableMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (MaxStaminaTableMaster item : this.result) {
                this.cache.put(parentKey, MaxStaminaTableMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, MaxStaminaTableMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public MaxStaminaTableMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        MaxStaminaTableMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<MaxStaminaTableMaster> iterator() {
        return this;
    }
}

