/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.showcase.model.DisplayItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Showcase
implements IModel,
Serializable,
Comparable<Showcase> {
    private String showcaseId;
    private String name;
    private String metadata;
    private String salesPeriodEventId;
    private List<DisplayItem> displayItems;

    public String getShowcaseId() {
        return this.showcaseId;
    }

    public void setShowcaseId(String showcaseId) {
        this.showcaseId = showcaseId;
    }

    public Showcase withShowcaseId(String showcaseId) {
        this.showcaseId = showcaseId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Showcase withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Showcase withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public String getSalesPeriodEventId() {
        return this.salesPeriodEventId;
    }

    public void setSalesPeriodEventId(String salesPeriodEventId) {
        this.salesPeriodEventId = salesPeriodEventId;
    }

    public Showcase withSalesPeriodEventId(String salesPeriodEventId) {
        this.salesPeriodEventId = salesPeriodEventId;
        return this;
    }

    public List<DisplayItem> getDisplayItems() {
        return this.displayItems;
    }

    public void setDisplayItems(List<DisplayItem> displayItems) {
        this.displayItems = displayItems;
    }

    public Showcase withDisplayItems(List<DisplayItem> displayItems) {
        this.displayItems = displayItems;
        return this;
    }

    public static Showcase fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new Showcase().withShowcaseId(data.get("showcaseId") == null || data.get("showcaseId").isNull() ? null : data.get("showcaseId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withSalesPeriodEventId(data.get("salesPeriodEventId") == null || data.get("salesPeriodEventId").isNull() ? null : data.get("salesPeriodEventId").asText()).withDisplayItems(data.get("displayItems") == null || data.get("displayItems").isNull() ? new ArrayList<DisplayItem>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("displayItems").elements(), 256), false).map(item -> DisplayItem.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("showcaseId", Showcase.this.getShowcaseId());
                this.put("name", Showcase.this.getName());
                this.put("metadata", Showcase.this.getMetadata());
                this.put("salesPeriodEventId", Showcase.this.getSalesPeriodEventId());
                this.put("displayItems", Showcase.this.getDisplayItems() == null ? new ArrayList() : Showcase.this.getDisplayItems().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(Showcase o) {
        return this.showcaseId.compareTo(o.showcaseId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.showcaseId == null ? 0 : this.showcaseId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.salesPeriodEventId == null ? 0 : this.salesPeriodEventId.hashCode());
        result = 31 * result + (this.displayItems == null ? 0 : this.displayItems.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Showcase other = (Showcase)o;
        if (this.showcaseId == null) {
            return other.showcaseId == null;
        }
        if (!this.showcaseId.equals(other.showcaseId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.salesPeriodEventId == null) {
            return other.salesPeriodEventId == null;
        }
        if (!this.salesPeriodEventId.equals(other.salesPeriodEventId)) {
            return false;
        }
        if (this.displayItems == null) {
            return other.displayItems == null;
        }
        return this.displayItems.equals(other.displayItems);
    }
}

