/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.iterator.DescribeShowcasesByUserIdIterator;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.domain.model.ShowcaseDomain;

public class UserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public DescribeShowcasesByUserIdIterator showcases() {
        return new DescribeShowcasesByUserIdIterator(this.cache, this.client, this.namespaceName, this.userId);
    }

    public ShowcaseDomain showcase(String showcaseName) {
        return new ShowcaseDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.userId, showcaseName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

