/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.model.SalesItemGroupMaster;
import io.gs2.showcase.request.DeleteSalesItemGroupMasterRequest;
import io.gs2.showcase.request.GetSalesItemGroupMasterRequest;
import io.gs2.showcase.request.UpdateSalesItemGroupMasterRequest;
import io.gs2.showcase.result.DeleteSalesItemGroupMasterResult;
import io.gs2.showcase.result.GetSalesItemGroupMasterResult;
import io.gs2.showcase.result.UpdateSalesItemGroupMasterResult;

public class SalesItemGroupMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String salesItemGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getSalesItemGroupName() {
        return this.salesItemGroupName;
    }

    public SalesItemGroupMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String salesItemGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.salesItemGroupName = salesItemGroupName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemGroupMaster");
    }

    private SalesItemGroupMaster get(GetSalesItemGroupMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemGroupName(this.salesItemGroupName);
        GetSalesItemGroupMasterResult result = this.client.getSalesItemGroupMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(request.getSalesItemGroupName() != null ? request.getSalesItemGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SalesItemGroupMasterDomain update(UpdateSalesItemGroupMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemGroupName(this.salesItemGroupName);
        UpdateSalesItemGroupMasterResult result = this.client.updateSalesItemGroupMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(request.getSalesItemGroupName() != null ? request.getSalesItemGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SalesItemGroupMasterDomain domain = this;
        return domain;
    }

    public SalesItemGroupMasterDomain delete(DeleteSalesItemGroupMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withSalesItemGroupName(this.salesItemGroupName);
        DeleteSalesItemGroupMasterResult result = null;
        try {
            result = this.client.deleteSalesItemGroupMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(request.getSalesItemGroupName() != null ? request.getSalesItemGroupName().toString() : null), SalesItemGroupMaster.class);
        SalesItemGroupMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String salesItemGroupName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, salesItemGroupName, childType);
    }

    public static String createCacheKey(String salesItemGroupName) {
        return String.join((CharSequence)":", salesItemGroupName);
    }

    public SalesItemGroupMaster model() {
        SalesItemGroupMaster value = this.cache.get(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(this.getSalesItemGroupName() != null ? this.getSalesItemGroupName().toString() : null), SalesItemGroupMaster.class);
        if (value == null) {
            try {
                this.get(new GetSalesItemGroupMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(this.getSalesItemGroupName() != null ? this.getSalesItemGroupName().toString() : null), SalesItemGroupMaster.class);
            }
            value = this.cache.get(this.parentKey, SalesItemGroupMasterDomain.createCacheKey(this.getSalesItemGroupName() != null ? this.getSalesItemGroupName().toString() : null), SalesItemGroupMaster.class);
        }
        return value;
    }
}

