/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.iterator.DescribeSalesItemGroupMastersIterator;
import io.gs2.showcase.domain.iterator.DescribeSalesItemMastersIterator;
import io.gs2.showcase.domain.iterator.DescribeShowcaseMastersIterator;
import io.gs2.showcase.domain.model.CurrentShowcaseMasterDomain;
import io.gs2.showcase.domain.model.DisplayItemDomain;
import io.gs2.showcase.domain.model.DisplayItemMasterDomain;
import io.gs2.showcase.domain.model.SalesItemDomain;
import io.gs2.showcase.domain.model.SalesItemGroupDomain;
import io.gs2.showcase.domain.model.SalesItemGroupMasterDomain;
import io.gs2.showcase.domain.model.SalesItemMasterDomain;
import io.gs2.showcase.domain.model.ShowcaseMasterDomain;
import io.gs2.showcase.domain.model.UserAccessTokenDomain;
import io.gs2.showcase.domain.model.UserDomain;
import io.gs2.showcase.model.Namespace;
import io.gs2.showcase.request.CreateSalesItemGroupMasterRequest;
import io.gs2.showcase.request.CreateSalesItemMasterRequest;
import io.gs2.showcase.request.CreateShowcaseMasterRequest;
import io.gs2.showcase.request.DeleteNamespaceRequest;
import io.gs2.showcase.request.GetNamespaceRequest;
import io.gs2.showcase.request.GetNamespaceStatusRequest;
import io.gs2.showcase.request.UpdateNamespaceRequest;
import io.gs2.showcase.result.CreateSalesItemGroupMasterResult;
import io.gs2.showcase.result.CreateSalesItemMasterResult;
import io.gs2.showcase.result.CreateShowcaseMasterResult;
import io.gs2.showcase.result.DeleteNamespaceResult;
import io.gs2.showcase.result.GetNamespaceResult;
import io.gs2.showcase.result.GetNamespaceStatusResult;
import io.gs2.showcase.result.UpdateNamespaceResult;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "showcase:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public SalesItemMasterDomain createSalesItemMaster(CreateSalesItemMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateSalesItemMasterResult result = this.client.createSalesItemMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, SalesItemMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SalesItemMasterDomain domain = new SalesItemMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public SalesItemGroupMasterDomain createSalesItemGroupMaster(CreateSalesItemGroupMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateSalesItemGroupMasterResult result = this.client.createSalesItemGroupMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "SalesItemGroupMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, SalesItemGroupMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SalesItemGroupMasterDomain domain = new SalesItemGroupMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public ShowcaseMasterDomain createShowcaseMaster(CreateShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateShowcaseMasterResult result = this.client.createShowcaseMaster(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "ShowcaseMaster");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ShowcaseMasterDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ShowcaseMasterDomain domain = new ShowcaseMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public CurrentShowcaseMasterDomain currentShowcaseMaster() {
        return new CurrentShowcaseMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public SalesItemDomain salesItem() {
        return new SalesItemDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public SalesItemGroupDomain salesItemGroup() {
        return new SalesItemGroupDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DisplayItemDomain displayItem() {
        return new DisplayItemDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public UserDomain user(String userId) {
        return new UserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, userId);
    }

    public UserAccessTokenDomain accessToken(AccessToken accessToken) {
        return new UserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, accessToken);
    }

    public DescribeSalesItemMastersIterator salesItemMasters() {
        return new DescribeSalesItemMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public SalesItemMasterDomain salesItemMaster(String salesItemName) {
        return new SalesItemMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, salesItemName);
    }

    public DescribeSalesItemGroupMastersIterator salesItemGroupMasters() {
        return new DescribeSalesItemGroupMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public SalesItemGroupMasterDomain salesItemGroupMaster(String salesItemGroupName) {
        return new SalesItemGroupMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, salesItemGroupName);
    }

    public DisplayItemMasterDomain displayItemMaster() {
        return new DisplayItemMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName);
    }

    public DescribeShowcaseMastersIterator showcaseMasters() {
        return new DescribeShowcaseMastersIterator(this.cache, this.client, this.namespaceName);
    }

    public ShowcaseMasterDomain showcaseMaster(String showcaseName) {
        return new ShowcaseMasterDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, showcaseName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

