/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.NamespaceDomain;
import io.gs2.showcase.model.CurrentShowcaseMaster;
import io.gs2.showcase.request.ExportMasterRequest;
import io.gs2.showcase.request.GetCurrentShowcaseMasterRequest;
import io.gs2.showcase.request.UpdateCurrentShowcaseMasterFromGitHubRequest;
import io.gs2.showcase.request.UpdateCurrentShowcaseMasterRequest;
import io.gs2.showcase.result.ExportMasterResult;
import io.gs2.showcase.result.GetCurrentShowcaseMasterResult;
import io.gs2.showcase.result.UpdateCurrentShowcaseMasterFromGitHubResult;
import io.gs2.showcase.result.UpdateCurrentShowcaseMasterResult;

public class CurrentShowcaseMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ShowcaseRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentShowcaseMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ShowcaseRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentShowcaseMaster");
    }

    public CurrentShowcaseMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentShowcaseMasterDomain domain = this;
        return domain;
    }

    private CurrentShowcaseMaster get(GetCurrentShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentShowcaseMasterResult result = this.client.getCurrentShowcaseMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentShowcaseMasterDomain update(UpdateCurrentShowcaseMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentShowcaseMasterResult result = this.client.updateCurrentShowcaseMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentShowcaseMasterDomain domain = this;
        return domain;
    }

    public CurrentShowcaseMasterDomain updateFromGitHub(UpdateCurrentShowcaseMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentShowcaseMasterFromGitHubResult result = this.client.updateCurrentShowcaseMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentShowcaseMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "showcase", namespaceName, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public CurrentShowcaseMaster model() {
        CurrentShowcaseMaster value = this.cache.get(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), CurrentShowcaseMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentShowcaseMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), CurrentShowcaseMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentShowcaseMasterDomain.createCacheKey(), CurrentShowcaseMaster.class);
        }
        return value;
    }
}

