/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.domain.iterator;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.showcase.Gs2ShowcaseRestClient;
import io.gs2.showcase.domain.model.ShowcaseDomain;
import io.gs2.showcase.domain.model.UserDomain;
import io.gs2.showcase.model.Showcase;
import io.gs2.showcase.request.DescribeShowcasesRequest;
import io.gs2.showcase.result.DescribeShowcasesResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeShowcasesIterator
implements Iterator<Showcase>,
Iterable<Showcase> {
    CacheDatabase cache;
    Gs2ShowcaseRestClient client;
    String namespaceName;
    AccessToken accessToken;
    boolean last;
    List<Showcase> result;
    Integer fetchSize;

    public DescribeShowcasesIterator(CacheDatabase cache, Gs2ShowcaseRestClient client, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.last = false;
        this.result = new ArrayList<Showcase>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Showcase");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Showcase.class)) {
            this.result = this.cache.list(parentKey, Showcase.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeShowcasesResult r = this.client.describeShowcases(new DescribeShowcasesRequest().withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null));
            this.result = r.getItems();
            this.last = true;
            for (Showcase item : this.result) {
                this.cache.put(parentKey, ShowcaseDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Showcase.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Showcase next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Showcase ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Showcase> iterator() {
        return this;
    }
}

