/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.script.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.script.Gs2ScriptRestClient;
import io.gs2.script.domain.iterator.DescribeScriptsIterator;
import io.gs2.script.domain.model.ScriptDomain;
import io.gs2.script.model.Namespace;
import io.gs2.script.request.CreateScriptFromGitHubRequest;
import io.gs2.script.request.CreateScriptRequest;
import io.gs2.script.request.DebugInvokeRequest;
import io.gs2.script.request.DeleteNamespaceRequest;
import io.gs2.script.request.GetNamespaceRequest;
import io.gs2.script.request.GetNamespaceStatusRequest;
import io.gs2.script.request.InvokeScriptRequest;
import io.gs2.script.request.UpdateNamespaceRequest;
import io.gs2.script.result.CreateScriptFromGitHubResult;
import io.gs2.script.result.CreateScriptResult;
import io.gs2.script.result.DebugInvokeResult;
import io.gs2.script.result.DeleteNamespaceResult;
import io.gs2.script.result.GetNamespaceResult;
import io.gs2.script.result.GetNamespaceStatusResult;
import io.gs2.script.result.InvokeScriptResult;
import io.gs2.script.result.UpdateNamespaceResult;
import java.util.List;

public class NamespaceDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScriptRestClient client;
    private final String namespaceName;
    private final String parentKey;
    String status;
    Integer code;
    String result;
    Integer executeTime;
    Integer charged;
    List<String> output;
    String nextPageToken;

    public String getStatus() {
        return this.status;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getResult() {
        return this.result;
    }

    public Integer getExecuteTime() {
        return this.executeTime;
    }

    public Integer getCharged() {
        return this.charged;
    }

    public List<String> getOutput() {
        return this.output;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public NamespaceDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScriptRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = "script:Namespace";
    }

    public NamespaceDomain getStatus(GetNamespaceStatusRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceStatusResult result = this.client.getNamespaceStatus(request);
        NamespaceDomain domain = this;
        this.status = result.getStatus();
        return domain;
    }

    private Namespace get(GetNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetNamespaceResult result = this.client.getNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public NamespaceDomain update(UpdateNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateNamespaceResult result = this.client.updateNamespace(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        return domain;
    }

    public NamespaceDomain delete(DeleteNamespaceRequest request) {
        request.withNamespaceName(this.namespaceName);
        DeleteNamespaceResult result = null;
        try {
            result = this.client.deleteNamespace(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), Namespace.class);
        NamespaceDomain domain = this;
        return domain;
    }

    public ScriptDomain createScript(CreateScriptRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateScriptResult result = this.client.createScript(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Script");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ScriptDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScriptDomain domain = new ScriptDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public ScriptDomain createScriptFromGitHub(CreateScriptFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        CreateScriptFromGitHubResult result = this.client.createScriptFromGitHub(request);
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Script");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ScriptDomain.createCacheKey(result.getItem().getName() != null ? result.getItem().getName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScriptDomain domain = new ScriptDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getName());
        return domain;
    }

    public NamespaceDomain invokeScript(InvokeScriptRequest request) {
        InvokeScriptResult result = this.client.invokeScript(request);
        for (String item : result.getOutput()) {
            if (item == null) continue;
            this.cache.put(this.parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        this.code = result.getCode();
        this.result = result.getResult();
        this.charged = result.getCharged();
        this.output = result.getOutput();
        return domain;
    }

    public NamespaceDomain debugInvoke(DebugInvokeRequest request) {
        DebugInvokeResult result = this.client.debugInvoke(request);
        for (String item : result.getOutput()) {
            if (item == null) continue;
            this.cache.put(this.parentKey, item, item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        NamespaceDomain domain = this;
        this.code = result.getCode();
        this.result = result.getResult();
        this.executeTime = result.getExecuteTime();
        this.charged = result.getCharged();
        this.output = result.getOutput();
        return domain;
    }

    public DescribeScriptsIterator scripts() {
        return new DescribeScriptsIterator(this.cache, this.client, this.namespaceName);
    }

    public ScriptDomain script(String scriptName) {
        return new ScriptDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, scriptName);
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "script", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public Namespace model() {
        Namespace value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        if (value == null) {
            try {
                this.get(new GetNamespaceRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
            }
            value = this.cache.get(this.parentKey, NamespaceDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), Namespace.class);
        }
        return value;
    }
}

