/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.UserDomain;
import io.gs2.schedule.model.Event;
import io.gs2.schedule.model.Trigger;
import io.gs2.schedule.request.DeleteTriggerByUserIdRequest;
import io.gs2.schedule.request.GetTriggerByUserIdRequest;
import io.gs2.schedule.request.TriggerByUserIdRequest;
import io.gs2.schedule.result.DeleteTriggerByUserIdResult;
import io.gs2.schedule.result.GetTriggerByUserIdResult;
import io.gs2.schedule.result.TriggerByUserIdResult;

public class TriggerDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScheduleRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String triggerName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public TriggerDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String triggerName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScheduleRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.triggerName = triggerName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Trigger");
    }

    private Trigger get(GetTriggerByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTriggerName(this.triggerName);
        GetTriggerByUserIdResult result = this.client.getTriggerByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TriggerDomain.createCacheKey(request.getTriggerName() != null ? request.getTriggerName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public TriggerDomain trigger(TriggerByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTriggerName(this.triggerName);
        TriggerByUserIdResult result = this.client.triggerByUserId(request);
        this.cache.listCacheClear(this.parentKey.replace("Trigger", "Event"), Event.class);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TriggerDomain.createCacheKey(request.getTriggerName() != null ? request.getTriggerName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        TriggerDomain domain = this;
        return domain;
    }

    public TriggerDomain delete(DeleteTriggerByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withTriggerName(this.triggerName);
        DeleteTriggerByUserIdResult result = null;
        try {
            result = this.client.deleteTriggerByUserId(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, TriggerDomain.createCacheKey(request.getTriggerName() != null ? request.getTriggerName().toString() : null), Trigger.class);
        TriggerDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String triggerName, String childType) {
        return String.join((CharSequence)":", "schedule", namespaceName, userId, triggerName, childType);
    }

    public static String createCacheKey(String triggerName) {
        return String.join((CharSequence)":", triggerName);
    }

    public Trigger model() {
        Trigger value = this.cache.get(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
        if (value == null) {
            try {
                this.get(new GetTriggerByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
            }
            value = this.cache.get(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
        }
        return value;
    }
}

