/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.TriggerDomain;
import io.gs2.schedule.domain.model.UserDomain;
import io.gs2.schedule.model.Trigger;
import io.gs2.schedule.request.DeleteTriggerRequest;
import io.gs2.schedule.request.GetTriggerRequest;
import io.gs2.schedule.result.DeleteTriggerResult;
import io.gs2.schedule.result.GetTriggerResult;

public class TriggerAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScheduleRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String triggerName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public TriggerAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String triggerName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScheduleRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.triggerName = triggerName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Trigger");
    }

    private Trigger get(GetTriggerRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTriggerName(this.triggerName);
        GetTriggerResult result = this.client.getTrigger(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, TriggerDomain.createCacheKey(request.getTriggerName() != null ? request.getTriggerName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public TriggerAccessTokenDomain delete(DeleteTriggerRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTriggerName(this.triggerName);
        DeleteTriggerResult result = null;
        try {
            result = this.client.deleteTrigger(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, TriggerDomain.createCacheKey(request.getTriggerName() != null ? request.getTriggerName().toString() : null), Trigger.class);
        TriggerAccessTokenDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String triggerName, String childType) {
        return String.join((CharSequence)":", "schedule", namespaceName, userId, triggerName, childType);
    }

    public static String createCacheKey(String triggerName) {
        return String.join((CharSequence)":", triggerName);
    }

    public Trigger model() {
        Trigger value = this.cache.get(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
        if (value == null) {
            try {
                this.get(new GetTriggerRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
            }
            value = this.cache.get(this.parentKey, TriggerDomain.createCacheKey(this.getTriggerName() != null ? this.getTriggerName().toString() : null), Trigger.class);
        }
        return value;
    }
}

