/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.NamespaceDomain;
import io.gs2.schedule.model.EventMaster;
import io.gs2.schedule.request.DeleteEventMasterRequest;
import io.gs2.schedule.request.GetEventMasterRequest;
import io.gs2.schedule.request.UpdateEventMasterRequest;
import io.gs2.schedule.result.DeleteEventMasterResult;
import io.gs2.schedule.result.GetEventMasterResult;
import io.gs2.schedule.result.UpdateEventMasterResult;

public class EventMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2ScheduleRestClient client;
    private final String namespaceName;
    private final String eventName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public EventMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String eventName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2ScheduleRestClient(session);
        this.namespaceName = namespaceName;
        this.eventName = eventName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EventMaster");
    }

    private EventMaster get(GetEventMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEventName(this.eventName);
        GetEventMasterResult result = this.client.getEventMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EventMasterDomain.createCacheKey(request.getEventName() != null ? request.getEventName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public EventMasterDomain update(UpdateEventMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEventName(this.eventName);
        UpdateEventMasterResult result = this.client.updateEventMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, EventMasterDomain.createCacheKey(request.getEventName() != null ? request.getEventName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        EventMasterDomain domain = this;
        return domain;
    }

    public EventMasterDomain delete(DeleteEventMasterRequest request) {
        request.withNamespaceName(this.namespaceName).withEventName(this.eventName);
        DeleteEventMasterResult result = null;
        try {
            result = this.client.deleteEventMaster(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        this.cache.delete(this.parentKey, EventMasterDomain.createCacheKey(request.getEventName() != null ? request.getEventName().toString() : null), EventMaster.class);
        EventMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String eventName, String childType) {
        return String.join((CharSequence)":", "schedule", namespaceName, eventName, childType);
    }

    public static String createCacheKey(String eventName) {
        return String.join((CharSequence)":", eventName);
    }

    public EventMaster model() {
        EventMaster value = this.cache.get(this.parentKey, EventMasterDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), EventMaster.class);
        if (value == null) {
            try {
                this.get(new GetEventMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, EventMasterDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), EventMaster.class);
            }
            value = this.cache.get(this.parentKey, EventMasterDomain.createCacheKey(this.getEventName() != null ? this.getEventName().toString() : null), EventMaster.class);
        }
        return value;
    }
}

