/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.TriggerDomain;
import io.gs2.schedule.domain.model.UserDomain;
import io.gs2.schedule.model.Trigger;
import io.gs2.schedule.request.DescribeTriggersByUserIdRequest;
import io.gs2.schedule.result.DescribeTriggersByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeTriggersByUserIdIterator
implements Iterator<Trigger>,
Iterable<Trigger> {
    CacheDatabase cache;
    Gs2ScheduleRestClient client;
    String namespaceName;
    String userId;
    String pageToken;
    boolean last;
    List<Trigger> result;
    Integer fetchSize;

    public DescribeTriggersByUserIdIterator(CacheDatabase cache, Gs2ScheduleRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<Trigger>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Trigger");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Trigger.class)) {
            this.result = this.cache.list(parentKey, Trigger.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeTriggersByUserIdResult r = this.client.describeTriggersByUserId(new DescribeTriggersByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (Trigger item : this.result) {
                this.cache.put(parentKey, TriggerDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Trigger.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Trigger next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Trigger ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Trigger> iterator() {
        return this;
    }
}

