/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.EventDomain;
import io.gs2.schedule.domain.model.UserDomain;
import io.gs2.schedule.model.Event;
import io.gs2.schedule.request.DescribeEventsByUserIdRequest;
import io.gs2.schedule.result.DescribeEventsByUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEventsByUserIdIterator
implements Iterator<Event>,
Iterable<Event> {
    CacheDatabase cache;
    Gs2ScheduleRestClient client;
    String namespaceName;
    String userId;
    boolean last;
    List<Event> result;
    Integer fetchSize;

    public DescribeEventsByUserIdIterator(CacheDatabase cache, Gs2ScheduleRestClient client, String namespaceName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.last = false;
        this.result = new ArrayList<Event>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Event");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, Event.class)) {
            this.result = this.cache.list(parentKey, Event.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeEventsByUserIdResult r = this.client.describeEventsByUserId(new DescribeEventsByUserIdRequest().withNamespaceName(this.namespaceName).withUserId(this.userId));
            this.result = r.getItems();
            this.last = true;
            for (Event item : this.result) {
                this.cache.put(parentKey, EventDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, Event.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public Event next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        Event ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }
}

