/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.schedule.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.schedule.Gs2ScheduleRestClient;
import io.gs2.schedule.domain.model.EventMasterDomain;
import io.gs2.schedule.domain.model.NamespaceDomain;
import io.gs2.schedule.model.EventMaster;
import io.gs2.schedule.request.DescribeEventMastersRequest;
import io.gs2.schedule.result.DescribeEventMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeEventMastersIterator
implements Iterator<EventMaster>,
Iterable<EventMaster> {
    CacheDatabase cache;
    Gs2ScheduleRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<EventMaster> result;
    Integer fetchSize;

    public DescribeEventMastersIterator(CacheDatabase cache, Gs2ScheduleRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<EventMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "EventMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, EventMaster.class)) {
            this.result = this.cache.list(parentKey, EventMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeEventMastersResult r = this.client.describeEventMasters(new DescribeEventMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (EventMaster item : this.result) {
                this.cache.put(parentKey, EventMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, EventMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public EventMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        EventMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<EventMaster> iterator() {
        return this;
    }
}

