/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.SubscribeUser;
import io.gs2.ranking.request.GetSubscribeByUserIdRequest;
import io.gs2.ranking.request.UnsubscribeByUserIdRequest;
import io.gs2.ranking.result.GetSubscribeByUserIdResult;
import io.gs2.ranking.result.UnsubscribeByUserIdResult;

public class SubscribeUserDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String categoryName;
    private final String targetUserId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getTargetUserId() {
        return this.targetUserId;
    }

    public SubscribeUserDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String categoryName, String targetUserId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.categoryName = categoryName;
        this.targetUserId = targetUserId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SubscribeUser");
    }

    private SubscribeUser get(GetSubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName).withTargetUserId(this.targetUserId);
        GetSubscribeByUserIdResult result = this.client.getSubscribeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public SubscribeUserDomain unsubscribe(UnsubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName).withTargetUserId(this.targetUserId);
        UnsubscribeByUserIdResult result = this.client.unsubscribeByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeUserDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String targetUserId, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, targetUserId, childType);
    }

    public static String createCacheKey(String categoryName, String targetUserId) {
        return String.join((CharSequence)":", categoryName, targetUserId);
    }

    public SubscribeUser model() {
        SubscribeUser value = this.cache.get(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
        if (value == null) {
            try {
                this.get(new GetSubscribeByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
            }
            value = this.cache.get(this.parentKey, SubscribeUserDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null, this.getTargetUserId() != null ? this.getTargetUserId().toString() : null), SubscribeUser.class);
        }
        return value;
    }
}

