/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.SubscribeUserDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Subscribe;
import io.gs2.ranking.request.SubscribeByUserIdRequest;
import io.gs2.ranking.result.SubscribeByUserIdResult;

public class SubscribeDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public SubscribeDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.categoryName = categoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Subscribe");
    }

    public SubscribeUserDomain subscribe(SubscribeByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName);
        SubscribeByUserIdResult result = this.client.subscribeByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SubscribeUser");
        if (result.getItem() != null) {
            this.cache.put(parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeUserDomain domain = new SubscribeUserDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getCategoryName(), result.getItem().getTargetUserId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public Subscribe model() {
        Subscribe value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Subscribe.class);
        return value;
    }
}

