/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.SubscribeDomain;
import io.gs2.ranking.domain.model.SubscribeUserAccessTokenDomain;
import io.gs2.ranking.domain.model.SubscribeUserDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Subscribe;
import io.gs2.ranking.request.SubscribeRequest;
import io.gs2.ranking.result.SubscribeResult;

public class SubscribeAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public SubscribeAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.categoryName = categoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Subscribe");
    }

    public SubscribeUserAccessTokenDomain subscribe(SubscribeRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName);
        SubscribeResult result = this.client.subscribe(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "SubscribeUser");
        if (result.getItem() != null) {
            this.cache.put(parentKey, SubscribeUserDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, request.getTargetUserId() != null ? request.getTargetUserId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        SubscribeUserAccessTokenDomain domain = new SubscribeUserAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getCategoryName(), result.getItem().getTargetUserId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public Subscribe model() {
        Subscribe value = this.cache.get(this.parentKey, SubscribeDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Subscribe.class);
        return value;
    }
}

