/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.ScoreDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Ranking;
import io.gs2.ranking.request.GetRankingByUserIdRequest;
import io.gs2.ranking.request.PutScoreByUserIdRequest;
import io.gs2.ranking.result.GetRankingByUserIdResult;
import io.gs2.ranking.result.PutScoreByUserIdResult;

public class RankingDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String userId;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public RankingDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String userId, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.userId = userId;
        this.categoryName = categoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Ranking");
    }

    private Ranking get(GetRankingByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName);
        GetRankingByUserIdResult result = this.client.getRankingByUserId(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RankingDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ScoreDomain putScore(PutScoreByUserIdRequest request) {
        request.withNamespaceName(this.namespaceName).withUserId(this.userId).withCategoryName(this.categoryName);
        PutScoreByUserIdResult result = this.client.putScoreByUserId(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "Score");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ScoreDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, result.getItem().getScorerUserId() != null ? result.getItem().getScorerUserId().toString() : null, result.getItem().getUniqueId() != null ? result.getItem().getUniqueId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScoreDomain domain = new ScoreDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), result.getItem().getUserId(), result.getItem().getCategoryName(), result.getItem().getScorerUserId(), result.getItem().getUniqueId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public Ranking model() {
        Ranking value = this.cache.get(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
        if (value == null) {
            try {
                this.get(new GetRankingByUserIdRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
            }
            value = this.cache.get(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
        }
        return value;
    }
}

