/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.RankingDomain;
import io.gs2.ranking.domain.model.ScoreAccessTokenDomain;
import io.gs2.ranking.domain.model.ScoreDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.Ranking;
import io.gs2.ranking.request.GetRankingRequest;
import io.gs2.ranking.request.PutScoreRequest;
import io.gs2.ranking.result.GetRankingResult;
import io.gs2.ranking.result.PutScoreResult;

public class RankingAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public RankingAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.categoryName = categoryName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "Singleton", "Ranking");
    }

    private Ranking get(GetRankingRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName);
        GetRankingResult result = this.client.getRanking(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, RankingDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public ScoreAccessTokenDomain putScore(PutScoreRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withCategoryName(this.categoryName);
        PutScoreResult result = this.client.putScore(request);
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Score");
        if (result.getItem() != null) {
            this.cache.put(parentKey, ScoreDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null, result.getItem().getScorerUserId() != null ? result.getItem().getScorerUserId().toString() : null, result.getItem().getUniqueId() != null ? result.getItem().getUniqueId().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        ScoreAccessTokenDomain domain = new ScoreAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getCategoryName(), result.getItem().getScorerUserId(), result.getItem().getUniqueId());
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, userId, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public Ranking model() {
        Ranking value = this.cache.get(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
        if (value == null) {
            try {
                this.get(new GetRankingRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
            }
            value = this.cache.get(this.parentKey, RankingDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), Ranking.class);
        }
        return value;
    }
}

