/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.model.CurrentRankingMaster;
import io.gs2.ranking.request.ExportMasterRequest;
import io.gs2.ranking.request.GetCurrentRankingMasterRequest;
import io.gs2.ranking.request.UpdateCurrentRankingMasterFromGitHubRequest;
import io.gs2.ranking.request.UpdateCurrentRankingMasterRequest;
import io.gs2.ranking.result.ExportMasterResult;
import io.gs2.ranking.result.GetCurrentRankingMasterResult;
import io.gs2.ranking.result.UpdateCurrentRankingMasterFromGitHubResult;
import io.gs2.ranking.result.UpdateCurrentRankingMasterResult;

public class CurrentRankingMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentRankingMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentRankingMaster");
    }

    public CurrentRankingMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRankingMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRankingMasterDomain domain = this;
        return domain;
    }

    private CurrentRankingMaster get(GetCurrentRankingMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentRankingMasterResult result = this.client.getCurrentRankingMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRankingMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentRankingMasterDomain update(UpdateCurrentRankingMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRankingMasterResult result = this.client.updateCurrentRankingMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRankingMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRankingMasterDomain domain = this;
        return domain;
    }

    public CurrentRankingMasterDomain updateFromGitHub(UpdateCurrentRankingMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentRankingMasterFromGitHubResult result = this.client.updateCurrentRankingMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentRankingMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentRankingMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentRankingMaster model() {
        CurrentRankingMaster value = this.cache.get(this.parentKey, CurrentRankingMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRankingMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentRankingMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentRankingMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRankingMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentRankingMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentRankingMaster.class);
        }
        return value;
    }
}

