/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.model.CategoryModel;
import io.gs2.ranking.request.GetCategoryModelRequest;
import io.gs2.ranking.result.GetCategoryModelResult;

public class CategoryModelDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2RankingRestClient client;
    private final String namespaceName;
    private final String categoryName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public CategoryModelDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, String categoryName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2RankingRestClient(session);
        this.namespaceName = namespaceName;
        this.categoryName = categoryName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CategoryModel");
    }

    private CategoryModel get(GetCategoryModelRequest request) {
        request.withNamespaceName(this.namespaceName).withCategoryName(this.categoryName);
        GetCategoryModelResult result = this.client.getCategoryModel(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CategoryModelDomain.createCacheKey(request.getCategoryName() != null ? request.getCategoryName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String categoryName, String childType) {
        return String.join((CharSequence)":", "ranking", namespaceName, categoryName, childType);
    }

    public static String createCacheKey(String categoryName) {
        return String.join((CharSequence)":", categoryName);
    }

    public CategoryModel model() {
        CategoryModel value = this.cache.get(this.parentKey, CategoryModelDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModel.class);
        if (value == null) {
            try {
                this.get(new GetCategoryModelRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CategoryModelDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModel.class);
            }
            value = this.cache.get(this.parentKey, CategoryModelDomain.createCacheKey(this.getCategoryName() != null ? this.getCategoryName().toString() : null), CategoryModel.class);
        }
        return value;
    }
}

