/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.SubscribeUserDomain;
import io.gs2.ranking.domain.model.UserDomain;
import io.gs2.ranking.model.SubscribeUser;
import io.gs2.ranking.request.DescribeSubscribesByCategoryNameAndUserIdRequest;
import io.gs2.ranking.result.DescribeSubscribesByCategoryNameAndUserIdResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeSubscribesByCategoryNameAndUserIdIterator
implements Iterator<SubscribeUser>,
Iterable<SubscribeUser> {
    CacheDatabase cache;
    Gs2RankingRestClient client;
    String namespaceName;
    String categoryName;
    String userId;
    boolean last;
    List<SubscribeUser> result;
    Integer fetchSize;

    public DescribeSubscribesByCategoryNameAndUserIdIterator(CacheDatabase cache, Gs2RankingRestClient client, String namespaceName, String categoryName, String userId) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.categoryName = categoryName;
        this.userId = userId;
        this.last = false;
        this.result = new ArrayList<SubscribeUser>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.userId != null ? this.userId.toString() : null, "SubscribeUser");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, SubscribeUser.class)) {
            this.result = this.cache.list(parentKey, SubscribeUser.class).stream().filter(item -> this.categoryName == null || item.getCategoryName().equals(this.categoryName)).collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeSubscribesByCategoryNameAndUserIdResult r = this.client.describeSubscribesByCategoryNameAndUserId(new DescribeSubscribesByCategoryNameAndUserIdRequest().withNamespaceName(this.namespaceName).withCategoryName(this.categoryName).withUserId(this.userId));
            this.result = r.getItems();
            this.last = true;
            for (SubscribeUser item2 : this.result) {
                this.cache.put(parentKey, SubscribeUserDomain.createCacheKey(item2.getCategoryName() != null ? item2.getCategoryName().toString() : null, item2.getTargetUserId() != null ? item2.getTargetUserId().toString() : null), item2, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, SubscribeUser.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public SubscribeUser next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        SubscribeUser ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<SubscribeUser> iterator() {
        return this;
    }
}

