/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.CategoryModelDomain;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.model.CategoryModel;
import io.gs2.ranking.request.DescribeCategoryModelsRequest;
import io.gs2.ranking.result.DescribeCategoryModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCategoryModelsIterator
implements Iterator<CategoryModel>,
Iterable<CategoryModel> {
    CacheDatabase cache;
    Gs2RankingRestClient client;
    String namespaceName;
    boolean last;
    List<CategoryModel> result;
    Integer fetchSize;

    public DescribeCategoryModelsIterator(CacheDatabase cache, Gs2RankingRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<CategoryModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CategoryModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, CategoryModel.class)) {
            this.result = this.cache.list(parentKey, CategoryModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeCategoryModelsResult r = this.client.describeCategoryModels(new DescribeCategoryModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (CategoryModel item : this.result) {
                this.cache.put(parentKey, CategoryModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, CategoryModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public CategoryModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        CategoryModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<CategoryModel> iterator() {
        return this;
    }
}

