/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.ranking.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.ranking.Gs2RankingRestClient;
import io.gs2.ranking.domain.model.CategoryModelMasterDomain;
import io.gs2.ranking.domain.model.NamespaceDomain;
import io.gs2.ranking.model.CategoryModelMaster;
import io.gs2.ranking.request.DescribeCategoryModelMastersRequest;
import io.gs2.ranking.result.DescribeCategoryModelMastersResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeCategoryModelMastersIterator
implements Iterator<CategoryModelMaster>,
Iterable<CategoryModelMaster> {
    CacheDatabase cache;
    Gs2RankingRestClient client;
    String namespaceName;
    String pageToken;
    boolean last;
    List<CategoryModelMaster> result;
    Integer fetchSize;

    public DescribeCategoryModelMastersIterator(CacheDatabase cache, Gs2RankingRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.pageToken = null;
        this.last = false;
        this.result = new ArrayList<CategoryModelMaster>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CategoryModelMaster");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, CategoryModelMaster.class)) {
            this.result = this.cache.list(parentKey, CategoryModelMaster.class).stream().collect(Collectors.toList());
            this.pageToken = null;
            this.last = true;
        } else {
            DescribeCategoryModelMastersResult r = this.client.describeCategoryModelMasters(new DescribeCategoryModelMastersRequest().withNamespaceName(this.namespaceName).withPageToken(this.pageToken).withLimit(this.fetchSize));
            this.result = r.getItems();
            this.pageToken = r.getNextPageToken();
            this.last = this.pageToken == null;
            for (CategoryModelMaster item : this.result) {
                this.cache.put(parentKey, CategoryModelMasterDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, CategoryModelMaster.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public CategoryModelMaster next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        CategoryModelMaster ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<CategoryModelMaster> iterator() {
        return this;
    }
}

