/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.iterator.DescribeCompletedQuestListsIterator;
import io.gs2.quest.domain.model.CompletedQuestListAccessTokenDomain;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.ProgressAccessTokenDomain;
import io.gs2.quest.domain.model.ProgressDomain;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.Progress;
import io.gs2.quest.request.DeleteProgressRequest;
import io.gs2.quest.request.StartRequest;
import io.gs2.quest.result.DeleteProgressResult;
import io.gs2.quest.result.StartResult;

public class UserAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String parentKey;
    String nextPageToken;

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public UserAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "User");
    }

    public StampSheetDomain start(StartRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        StartResult result = this.client.start(request);
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public ProgressAccessTokenDomain deleteProgress(DeleteProgressRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        DeleteProgressResult result = null;
        try {
            result = this.client.deleteProgress(request);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        String parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Progress");
        this.cache.delete(parentKey, ProgressDomain.createCacheKey(), Progress.class);
        ProgressAccessTokenDomain domain = new ProgressAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, request.getNamespaceName(), this.accessToken, result.getItem().getTransactionId());
        return domain;
    }

    public ProgressAccessTokenDomain progress(String transactionId) {
        return new ProgressAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, transactionId);
    }

    public DescribeCompletedQuestListsIterator completedQuestLists() {
        return new DescribeCompletedQuestListsIterator(this.cache, this.client, this.namespaceName, this.accessToken);
    }

    public CompletedQuestListAccessTokenDomain completedQuestList(String questGroupName) {
        return new CompletedQuestListAccessTokenDomain(this.cache, this.jobQueueDomain, this.stampSheetConfiguration, this.session, this.namespaceName, this.accessToken, questGroupName);
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, userId, childType);
    }

    public static String createCacheKey(String userId) {
        return String.join((CharSequence)":", userId);
    }
}

