/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.domain.StampSheetDomain;
import io.gs2.core.exception.Gs2Exception;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.exception.TransactionException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.ProgressDomain;
import io.gs2.quest.domain.model.QuestGroupModelDomain;
import io.gs2.quest.domain.model.QuestModelDomain;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.Progress;
import io.gs2.quest.request.EndRequest;
import io.gs2.quest.request.GetProgressRequest;
import io.gs2.quest.result.EndResult;
import io.gs2.quest.result.GetProgressResult;

public class ProgressAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String transactionId;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public ProgressAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String transactionId) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.transactionId = transactionId;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "Progress");
    }

    private Progress get(GetProgressRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null);
        GetProgressResult result = this.client.getProgress(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getQuestGroup() != null) {
            this.cache.put(this.parentKey, QuestGroupModelDomain.createCacheKey(result.getQuestGroup().getName() != null ? result.getQuestGroup().getName().toString() : null), result.getQuestGroup(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        if (result.getQuest() != null) {
            this.cache.put(this.parentKey, QuestModelDomain.createCacheKey(result.getQuest().getName() != null ? result.getQuest().getName().toString() : null), result.getQuest(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public StampSheetDomain end(EndRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withTransactionId(this.transactionId);
        EndResult result = this.client.end(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, ProgressDomain.createCacheKey(), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        StampSheetDomain stampSheet = new StampSheetDomain(this.cache, this.jobQueueDomain, this.session, result.getStampSheet(), result.getStampSheetEncryptionKeyId(), this.stampSheetConfiguration.namespaceName, this.stampSheetConfiguration.stampTaskEventHandler, this.stampSheetConfiguration.stampSheetEventHandler);
        try {
            stampSheet.run();
        }
        catch (Gs2Exception e) {
            throw new TransactionException(stampSheet, e);
        }
        return stampSheet;
    }

    public static String createCacheParentKey(String namespaceName, String userId, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, userId, childType);
    }

    public static String createCacheKey() {
        return "Singleton";
    }

    public Progress model() {
        Progress value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        if (value == null) {
            try {
                this.get(new GetProgressRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
            }
            value = this.cache.get(this.parentKey, ProgressDomain.createCacheKey(), Progress.class);
        }
        return value;
    }
}

