/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.model.CurrentQuestMaster;
import io.gs2.quest.request.ExportMasterRequest;
import io.gs2.quest.request.GetCurrentQuestMasterRequest;
import io.gs2.quest.request.UpdateCurrentQuestMasterFromGitHubRequest;
import io.gs2.quest.request.UpdateCurrentQuestMasterRequest;
import io.gs2.quest.result.ExportMasterResult;
import io.gs2.quest.result.GetCurrentQuestMasterResult;
import io.gs2.quest.result.UpdateCurrentQuestMasterFromGitHubResult;
import io.gs2.quest.result.UpdateCurrentQuestMasterResult;

public class CurrentQuestMasterDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public CurrentQuestMasterDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "CurrentQuestMaster");
    }

    public CurrentQuestMasterDomain exportMaster(ExportMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        ExportMasterResult result = this.client.exportMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentQuestMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentQuestMasterDomain domain = this;
        return domain;
    }

    private CurrentQuestMaster get(GetCurrentQuestMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        GetCurrentQuestMasterResult result = this.client.getCurrentQuestMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentQuestMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public CurrentQuestMasterDomain update(UpdateCurrentQuestMasterRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentQuestMasterResult result = this.client.updateCurrentQuestMaster(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentQuestMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentQuestMasterDomain domain = this;
        return domain;
    }

    public CurrentQuestMasterDomain updateFromGitHub(UpdateCurrentQuestMasterFromGitHubRequest request) {
        request.withNamespaceName(this.namespaceName);
        UpdateCurrentQuestMasterFromGitHubResult result = this.client.updateCurrentQuestMasterFromGitHub(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CurrentQuestMasterDomain.createCacheKey(request.getNamespaceName() != null ? request.getNamespaceName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        CurrentQuestMasterDomain domain = this;
        return domain;
    }

    public static String createCacheParentKey(String namespaceName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, childType);
    }

    public static String createCacheKey(String namespaceName) {
        return String.join((CharSequence)":", namespaceName);
    }

    public CurrentQuestMaster model() {
        CurrentQuestMaster value = this.cache.get(this.parentKey, CurrentQuestMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentQuestMaster.class);
        if (value == null) {
            try {
                this.get(new GetCurrentQuestMasterRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CurrentQuestMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentQuestMaster.class);
            }
            value = this.cache.get(this.parentKey, CurrentQuestMasterDomain.createCacheKey(this.getNamespaceName() != null ? this.getNamespaceName().toString() : null), CurrentQuestMaster.class);
        }
        return value;
    }
}

