/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.model;

import io.gs2.auth.model.AccessToken;
import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.core.domain.JobQueueDomain;
import io.gs2.core.domain.StampSheetConfiguration;
import io.gs2.core.exception.NotFoundException;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.CompletedQuestListDomain;
import io.gs2.quest.domain.model.UserDomain;
import io.gs2.quest.model.CompletedQuestList;
import io.gs2.quest.request.GetCompletedQuestListRequest;
import io.gs2.quest.result.GetCompletedQuestListResult;

public class CompletedQuestListAccessTokenDomain {
    private final CacheDatabase cache;
    private final JobQueueDomain jobQueueDomain;
    private final StampSheetConfiguration stampSheetConfiguration;
    private final Gs2RestSession session;
    private final Gs2QuestRestClient client;
    private final String namespaceName;
    private final AccessToken accessToken;
    private final String questGroupName;
    private final String parentKey;

    public String getNamespaceName() {
        return this.namespaceName;
    }

    public String getUserId() {
        return this.accessToken.getUserId();
    }

    public String getQuestGroupName() {
        return this.questGroupName;
    }

    public CompletedQuestListAccessTokenDomain(CacheDatabase cache, JobQueueDomain jobQueueDomain, StampSheetConfiguration stampSheetConfiguration, Gs2RestSession session, String namespaceName, AccessToken accessToken, String questGroupName) {
        this.cache = cache;
        this.jobQueueDomain = jobQueueDomain;
        this.stampSheetConfiguration = stampSheetConfiguration;
        this.session = session;
        this.client = new Gs2QuestRestClient(session);
        this.namespaceName = namespaceName;
        this.accessToken = accessToken;
        this.questGroupName = questGroupName;
        this.parentKey = UserDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, this.accessToken != null && this.accessToken.getUserId() != null ? this.accessToken.getUserId().toString() : null, "CompletedQuestList");
    }

    private CompletedQuestList get(GetCompletedQuestListRequest request) {
        request.withNamespaceName(this.namespaceName).withAccessToken(this.accessToken != null ? this.accessToken.getToken() : null).withQuestGroupName(this.questGroupName);
        GetCompletedQuestListResult result = this.client.getCompletedQuestList(request);
        if (result.getItem() != null) {
            this.cache.put(this.parentKey, CompletedQuestListDomain.createCacheKey(request.getQuestGroupName() != null ? request.getQuestGroupName().toString() : null), result.getItem(), System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
        }
        return result.getItem();
    }

    public static String createCacheParentKey(String namespaceName, String userId, String questGroupName, String childType) {
        return String.join((CharSequence)":", "quest", namespaceName, userId, questGroupName, childType);
    }

    public static String createCacheKey(String questGroupName) {
        return String.join((CharSequence)":", questGroupName);
    }

    public CompletedQuestList model() {
        CompletedQuestList value = this.cache.get(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
        if (value == null) {
            try {
                this.get(new GetCompletedQuestListRequest());
            }
            catch (NotFoundException e) {
                this.cache.delete(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
            }
            value = this.cache.get(this.parentKey, CompletedQuestListDomain.createCacheKey(this.getQuestGroupName() != null ? this.getQuestGroupName().toString() : null), CompletedQuestList.class);
        }
        return value;
    }
}

