/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest.domain.iterator;

import io.gs2.core.domain.CacheDatabase;
import io.gs2.core.domain.Gs2;
import io.gs2.quest.Gs2QuestRestClient;
import io.gs2.quest.domain.model.NamespaceDomain;
import io.gs2.quest.domain.model.QuestGroupModelDomain;
import io.gs2.quest.model.QuestGroupModel;
import io.gs2.quest.request.DescribeQuestGroupModelsRequest;
import io.gs2.quest.result.DescribeQuestGroupModelsResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class DescribeQuestGroupModelsIterator
implements Iterator<QuestGroupModel>,
Iterable<QuestGroupModel> {
    CacheDatabase cache;
    Gs2QuestRestClient client;
    String namespaceName;
    boolean last;
    List<QuestGroupModel> result;
    Integer fetchSize;

    public DescribeQuestGroupModelsIterator(CacheDatabase cache, Gs2QuestRestClient client, String namespaceName) {
        this.cache = cache;
        this.client = client;
        this.namespaceName = namespaceName;
        this.last = false;
        this.result = new ArrayList<QuestGroupModel>();
        this.fetchSize = null;
        this.load();
    }

    private void load() {
        String parentKey = NamespaceDomain.createCacheParentKey(this.namespaceName != null ? this.namespaceName.toString() : null, "QuestGroupModel");
        String listParentKey = parentKey;
        if (this.cache.isListCached(listParentKey, QuestGroupModel.class)) {
            this.result = this.cache.list(parentKey, QuestGroupModel.class).stream().collect(Collectors.toList());
            this.last = true;
        } else {
            DescribeQuestGroupModelsResult r = this.client.describeQuestGroupModels(new DescribeQuestGroupModelsRequest().withNamespaceName(this.namespaceName));
            this.result = r.getItems();
            this.last = true;
            for (QuestGroupModel item : this.result) {
                this.cache.put(parentKey, QuestGroupModelDomain.createCacheKey(item.getName() != null ? item.getName().toString() : null), item, System.currentTimeMillis() + 60000L * Gs2.defaultCacheMinutes);
            }
            if (this.last) {
                this.cache.listCached(listParentKey, QuestGroupModel.class);
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.result.size() != 0 || !this.last;
    }

    @Override
    public QuestGroupModel next() {
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        if (this.result.size() == 0) {
            return null;
        }
        QuestGroupModel ret = this.result.get(0);
        this.result = this.result.subList(1, this.result.size());
        if (this.result.size() == 0 && !this.last) {
            this.load();
        }
        return ret;
    }

    @Override
    public Iterator<QuestGroupModel> iterator() {
        return this;
    }
}

